import req from '@/request.js'
const portal = window.context.portal
const headers = {
  'Content-type': 'application/x-www-form-urlencoded'
}
export default {
  // 分页查询
  queryPageFillList(data, status, cb) {
    req
      .post(
        portal +
          `/majorProjects/bizPilotProjectFill/v1/queryPageFillList?flowType=2&isAffirm=${status}`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 历史数据分页查询
  queryPageHistoryList(data, status, cb) {
    req
      .post(
        portal +
          `/majorProjects/bizPilotProjectFill/v1/queryPageFillList?isClosing=0&flowType=2&isAffirm=${status}`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 根据项目ID获取初始化目标信息
  getDefaultQuaObj(data, cb) {
    req
      .post(
        portal + '/majorProjects/pilotSpecificSchedulePush/v1/examineInit',
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 保存为草稿
  save(data, cb) {
    req
      .put(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/pilotSpecificSchedulePushAndMeasurePushSave',
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 保存并上报
  saveAndSubmit(data, cb) {
    req
      .put(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/pilotSpecificSchedulePushAndMeasurePushSaveCommit',
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 获取待审核数据
  getAuditData(id, cb) {
    req
      .get(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/getDetails?id=' +
          id
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 审核
  verify(data, cb) {
    req
      .post(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/pilotSpecificSchedulePushAndMeasurePushExamine',
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 上报
  commit(id, cb) {
    req
      .get(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/pilotSpecificSchedulePushCommit?id=' +
          id
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 编辑后审核
  saveAndCommit(data, cb) {
    req
      .put(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/pilotSpecificSchedulePushAndMeasurePushUpdate',
        data
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 查询历史审核记录
  getHistoryDetailById(id, cb) {
    req
      .get(
        portal +
          '/majorProjects/pilotSpecificSchedulePush/v1/getHisDetails?projectId=' +
          id
      )
      .then(res => {
        cb(res.data)
      })
  },
  // 专项小组审核查询
  getGroupAuditData(data, cb) {
    req
      .post(
        portal +
          `/majorProjects/bizPilotProjectFill/v1/queryPageFillGroup?flowType=2`,
        data
      )
      .then(res => {
        cb(res.data)
      })
  }
}
