import req from '@/request.js'
const portal = window.context.portal
export default {
    // 项目基础信息录入
    majorProjectAdd(data, cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    // 项目基础信息修改
    majorProjectUpdate(data, cb) {
        req.put(portal + `/bizMunicipalNotSatrtProjectManagement/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    // 批量删除列表数据
    deleteTableData(ids,cb) {
        req.remove(portal + `/bizMunicipalNotSatrtProjectManagement/v1/?ids=${ids}`).then(res => {
            cb(res.data)
        })
    },
    // 列表数据查询
    getMajorProjectData(data, cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    // 推进列表查询
    getAdvanceData(data, isAffirm,cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/queryByPage?isAffirm=${isAffirm}`, data).then(res => {
            cb(res.data)
        })
    },
    // 推进信息录入修改
    advanceSaveOrUpdate(data,cb) {
        req.post(portal + `/bizPilotNotStartMeasuresPush/v1/saveOrUpdateDate`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id查询推进信息 
    getfillDetailById(id,cb) {
        req.post(portal + `/bizPilotNotStartMeasuresPush/v1/findById/${id}`).then(res => {
            cb(res.data)
        })
    },
    // 根据id上报撤回
    updateStatusById(data,cb) {
        req.post(portal + `/bizPilotNotStartMeasuresPush/v1/updateById`,data).then(res => {
            cb(res.data)
        })
    },
    // 项目下发撤回
    updateCreateById(data,cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/updateById`,data).then(res => {
            cb(res.data)
        })
    },
    //项目调整
    projectAdjustById(ids,cb) {
        req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/closeProject?ids=${ids}`).then(res => {
            cb(res.data)
        })
    },
    // 本次更新数据查询
    getNewDataById(id,cb) {
        req.post(portal + `/bizPilotNotStartMeasuresPush/v1/findById?projectId=${id}`).then(res => {
            cb(res.data)
        })
    },
    // 历史数据查询
    getHistoryData(data, cb) {
        req.post(portal + `/bizPilotNotStartMeasuresPush/v1/findHisById?projectId=${data.id}&planDate=${data.planDate}`).then(res => {
            cb(res.data)
        })
    }
}