package com.artfess.es.unit;


import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.indices.GetFieldMappingsResponse;
import org.elasticsearch.client.indices.IndexTemplateMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface ElasticIndexApplication {

    /**
     * 判断索引的存在性
     * @param indexName 索引名称
     * @return 是否存在
     */
    boolean isIndexExist(String indexName);

    /**
     * 根据索引模板创建索引
     * @param newIndexName 索引名称
     * @param indexTempLateName 索引模板名称
     * @return 是否存在
     */
    boolean createIndex(String newIndexName,String indexTempLateName) throws IOException;

    /**
     * 创建索引
     * @param newIndexName 索引名称
     * @param settings 索引设置
     * @param xContentBuilder 映射
     * @return
     * @throws IOException
     */
    boolean createIndex(String newIndexName, Settings settings, XContentBuilder xContentBuilder) throws IOException;

    /**
     * 获取索引模板
     * @param indexTemplateName 索引模板名称
     * @return
     * @throws IOException
     */
    List<IndexTemplateMetaData> getIndexTemplate(String indexTemplateName) throws IOException;

    /**
     * 获取指定索引的映射信息
     * @param indexName 索引名称
     * @return  索引的映射信息
     */
    List<Map<String, Object>> getIndexMapping(String indexName);

    /**
     * 获取指定索引的字段映射信息
     * @param indexName 索引名称
     * @param fieldNames 字段名集合
     * @return 索引字段的映射信息
     */
    Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> getIndexFieldMapping(String indexName, List<String> fieldNames);

    /**
     * 刷新指定的索引
     * @param indexName 索引名称
     */
    RefreshResponse refreshIndex(String... indexName) throws IOException;

    /**
     * 刷新所有索引
     */
    RefreshResponse refreshIndex() throws IOException;

}
