package com.artfess.portal.persistence.manager.impl;

import com.artfess.sysConfig.service.AuthorityManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.*;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.model.SysIndexLayoutManage;
import com.artfess.portal.model.SysObjRights;
import com.artfess.portal.persistence.dao.SysIndexLayoutManageDao;
import com.artfess.portal.persistence.manager.SysIndexLayoutManageManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 布局管理 Service类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author maoww
 * @email maoww@jee-soft.cn
 * @date 2018年6月11日
 */
@Service("sysIndexLayoutManageManager")
public class SysIndexLayoutManageManagerImpl extends BaseManagerImpl<SysIndexLayoutManageDao, SysIndexLayoutManage> implements SysIndexLayoutManageManager{
	@Resource
	private SysIndexColumnManagerImpl sysIndexColumnService;
	@Resource
	private AuthorityManager authorityManager;

	@Resource
	BaseContext baseContext;

	public SysIndexLayoutManageManagerImpl() {
	}

	@Override
	public SysIndexLayoutManage getLayoutList(String id,List<SysIndexColumn> columnList,Short type) {
		SysIndexLayoutManage sysIndexLayoutManage = null;
		if(StringUtil.isNotEmpty(id)){
			sysIndexLayoutManage = this.get(id);
		}
		if (BeanUtils.isEmpty(sysIndexLayoutManage))
			return getDefaultIndexLayout(type);
		String designHtml = "";
		try {
			designHtml = Base64.getFromBase64(sysIndexLayoutManage.getDesignHtml());
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		sysIndexLayoutManage.setDesignHtml(sysIndexColumnService.parserDesignHtml(
				designHtml, columnList));
		return sysIndexLayoutManage;
	}



	public String getDefaultMobileDesignHtml() {
		return   "<div class=\"lyrow ui-draggable\" style=\"display: block;\">"
				+ "<div class=\"preview\"><input type=\"text\" value=\"一列(12)\" readonly=\"readonly\" class=\"form-control\"></div>"
				+ "<div class=\"view\">"
				+ "<div class=\"row clearfix\">"
				+ "<div class=\"col-md-12 column ui-sortable\"></div>"
				+ "</div>"
				+ "</div>"
				+ "</div>";
	}
	public String getDefaultDesignHtml() {
		return   "<div class=\"lyrow ui-draggable\" style=\"display: block;\">"
				+ "<a href=\"#close\" class=\"remove label label-danger\"><i class=\"glyphicon-remove glyphicon\"></i> 删除</a>"
				+ "<span class=\"drag label label-default\"><i class=\"glyphicon glyphglyphicon glyphicon-move\"></i> 拖动</span>"
				+ "<div class=\"preview\"><input type=\"text\" value=\"一列(12)\" readonly=\"readonly\" class=\"form-control\"></div>"
				+ "<div class=\"view\">"
				+ "<div class=\"row clearfix\">"
				+ "<div class=\"col-md-12 column ui-sortable\"></div>"
				+ "</div>"
				+ "</div>"
				+ "</div>";
	}

	private SysIndexLayoutManage getDefaultIndexLayout(Short type) {
		String designHtml  = getDefaultDesignHtml();
		if(type.equals(SysIndexLayoutManage.TYPE_MOBILE)){
			designHtml = getDefaultMobileDesignHtml();
		}
		SysIndexLayoutManage sysIndexLayoutManage  = new SysIndexLayoutManage();
		sysIndexLayoutManage.setDesignHtml(designHtml);
		sysIndexLayoutManage.setIsDef((short) 0);
		return sysIndexLayoutManage;
	}



	@Override
	public String getMyHasRightsLayout() {
		Map<String, Set<String>> relationMap= authorityManager.getUserRightMap();
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("relationMap", relationMap);
		params.put("objType", SysObjRights.RIGHT_TYPE_INDEX_MANAGE);
		List<SysIndexLayoutManage> list = baseMapper.getByUserIdFilter(params);
		if(BeanUtils.isNotEmpty(list))
			return list.get(0).getTemplateHtml();
		return "";
	}

	@Override
	public String getManagerLayout() {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("orgIds", null);
		params.put("isDef", 1);
		List<SysIndexLayoutManage> list = baseMapper.getManageLayout(params);
		if(BeanUtils.isNotEmpty(list) )
			return list.get(0).getDesignHtml();
		return null;
	}

	@Override
	public String obtainIndexManageData(String layoutId) {
		SysIndexLayoutManage sysIndexLayoutManage = this.get(layoutId);
		if (BeanUtils.isNotEmpty(sysIndexLayoutManage))
			return sysIndexLayoutManage.getTemplateHtml();
		//2.找自己拥有权限的管理布局 ，按是否默认，排序
		String html = getMyHasRightsLayout();
		if (BeanUtils.isNotEmpty(html))
			return html;
		//3、找自己所属子组织没权限但设置默认布局；
//		html = getHasRightsLayout();
		if (BeanUtils.isNotEmpty(html))
			return html;
		//4、如果找不到找系统管理员的设置默认布局;
		html = getManagerLayout();
		if (BeanUtils.isNotEmpty(html))
			return html;
		//5、再找不到则使用系统默认布局。
		if (BeanUtils.isEmpty(html))
			html = getDefaultDesignHtml();
		return "";
	}

	@Override
	public SysIndexLayoutManage getEnableByOrgIdAndType(String orgId,Short layoutType) {
		Map<String, Object> params = new HashMap<>();
		params.put("orgId", orgId);
		params.put("layoutType", layoutType);
		return baseMapper.getEnableByOrgIdAndType(params);
	}

	@Override
	public Boolean isExistName(String name) {
		Integer count = baseMapper.isExistName(name);
		return count > 0;
	}

	@Override
	public List<SysIndexLayoutManage> getByOrgIdAndLayoutType(String orgId, Short layoutType) {
		Map<String, Object> params = new HashMap<>();
		params.put("orgId", orgId);
		params.put("layoutType", layoutType);
		return baseMapper.getByOrgIdAndLayoutType(params);
	}

	@Override
	public void cancelOrgIsDef(String orgId, Short layoutType) {
		Map<String, Object> params = new HashMap<>();
		params.put("orgId", orgId);
		params.put("layoutType", layoutType);
		baseMapper.cancelOrgIsDef(params);
	}

	@Override
	public String obtainIndexManageMobileData(String layoutId) {
		SysIndexLayoutManage sysIndexLayoutManage = this.get(layoutId);
		return sysIndexLayoutManage.getTemplateHtml();
	}

	@Override
	public SysIndexLayoutManage getByIdAndType(String id, Short type) {
		Map<String, Object> params = new HashMap<>();
		params.put("id", id);
		params.put("type", type);
		return baseMapper.getByIdAndType(params);
	}

	@Override
	public String getMobileManagerLayout() {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("layoutType", SysIndexLayoutManage.TYPE_MOBILE);
		params.put("orgIds", null);
		params.put("isDef", 1);
		List<SysIndexLayoutManage> list = baseMapper.getManageLayout(params);
		if(BeanUtils.isNotEmpty(list) )
			return list.get(0).getDesignHtml();
		return null;
	}

	@Override
	public SysIndexLayoutManage getSharedByOrgIdAndType(String orgId,Short layoutType) {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("orgId", orgId);
		params.put("layoutType", layoutType);
		return baseMapper.getSharedByOrgIdAndType(params);
	}

	@Override
	public SysIndexLayoutManage getSharedByOrgIds(List<String> orgIds, Short layoutType) {
		List<SysIndexLayoutManage> list = baseMapper.getSharedByOrgIds(orgIds, layoutType);
		if(BeanUtils.isNotEmpty(list)) {
			return list.get(0);
		}
		return null;
	}

	@Override
	@Transactional
	public void setEnable(String id, Short enable) {
		SysIndexLayoutManage layout = this.get(id);
		//如果是启用，必须把现有的其他停用
		if(enable ==1){
			List<SysIndexLayoutManage> list = this.getByOrgIdAndLayoutType(layout.getOrgId(), layout.getLayoutType());
			for(SysIndexLayoutManage item : list){
				if(item.getEnable()==1){
					item.setEnable((short)0);
					this.update(item);
				}
			}
		}
		layout.setEnable(enable);
		this.update(layout);
	}

	@Override
	public SysIndexLayoutManage getDefaultLayoutManageByLayoutType(String layoutType) {
		QueryWrapper<SysIndexLayoutManage> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("LAYOUT_TYPE", Short.parseShort(layoutType)).eq("ENABLE",SysIndexLayoutManage.ENABLE).eq("IS_DEF", SysIndexLayoutManage.SET_DEF);
		SysIndexLayoutManage defaultLayout = baseMapper.selectOne(queryWrapper);
//		if(list.size()>0){
//			return  list.get(0);
//		}
		return defaultLayout;
	}

	@Override
	public String exportDefaultLayout(List<String> ids, boolean isDefault) throws Exception {
		if (BeanUtils.isEmpty(ids)) {
			throw new BaseException("请先选择要导出的默认布局");
		}
		QueryFilter<SysIndexLayoutManage> queryFilter = QueryFilter.build();
		if(isDefault){
			queryFilter.addFilter("IS_DEF","1", QueryOP.EQUAL, FieldRelation.AND);
		}else{
			queryFilter.addFilter("IS_DEF","0", QueryOP.EQUAL, FieldRelation.AND);
		}
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < ids.size(); i++) {
			sb.append(ids.get(i));
			if(i != ids.size() - 1){
				sb.append(",");
			}
		}
		queryFilter.addFilter("ID", sb.toString(), QueryOP.IN, FieldRelation.AND);
		PageList<SysIndexLayoutManage> query = this.query(queryFilter);
		if (BeanUtils.isNotEmpty(query.getRows())) {
			return JsonUtil.toJson(query.getRows());
		}else{
			throw new BaseException("未查找到任何记录");
		}

	}

	@Override
	@Transactional
	public void importFile(String uzPath, String orgId, boolean isDefault) {
		try {
			String fileName = isDefault ? "defaultLayout.json" : "orgLayout.json";
			String fileJson = FileUtil.readFile(uzPath + File.separator + fileName);
			List list = JsonUtil.toBean(fileJson, List.class);
			if (isDefault) {
				//导入默认栏目
				for (Object o : list) {
					SysIndexLayoutManage layout = JsonUtil.toBean(JsonUtil.toJson(o), SysIndexLayoutManage.class);
					SysIndexLayoutManage byId = this.getById(layout.getId());
					if (BeanUtils.isNotEmpty(byId)) {
						//更新
						baseMapper.updateById(layout);
					}else{
						baseMapper.insert(layout);
					}

				}
			}else{
				//导入部门门户
				if (StringUtil.isEmpty(orgId)) {
					throw new BaseException("请先选择部门");
				}
				for (Object o : list) {
					SysIndexLayoutManage orgLayout = JsonUtil.toBean(JsonUtil.toJson(o), SysIndexLayoutManage.class);
					orgLayout.setOrgId(orgId);
					SysIndexLayoutManage byId = this.getById(orgLayout.getId());
					if (BeanUtils.isNotEmpty(byId)) {
						if (StringUtil.equals(byId.getOrgId(),orgId)) {
							//更新
							baseMapper.updateById(orgLayout);
						}else{
							//导入到其它组织，修改ID
							orgLayout.setId(UniqueIdUtil.getSuid());
							baseMapper.insert(orgLayout);
						}
					}else{
						baseMapper.insert(orgLayout);
					}
				}
			}
		}catch (Exception e){
			throw new BaseException(e.getMessage());
		}
	}
}
