package com.artfess.portal.params;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wh
 * @Package com.sysplat.sys.modules.monitor.domain
 * @date 2020/7/22 10:28
 * @Description:
 */
public class ActuatorInfo {
    private static Map<String, String> map = new HashMap<>();

    static {
        //JVM
        map.put("jvm.memory.max", "JVM最大内存");
        map.put("jvm.memory.committed", "JVM可用内存");
        map.put("jvm.memory.used", "JVM已用内存");
        map.put("jvm.buffer.memory.used", "JVM缓冲区已用内存");
        map.put("jvm.buffer.count", "当前缓冲区数");
        map.put("jvm.threads.daemon", "JVM守护线程数");
        map.put("jvm.threads.live", "JVM当前活跃线程数");
        map.put("jvm.threads.peak", "JVM峰值线程数");
        map.put("jvm.classes.loaded", "加载classes数");
        map.put("jvm.classes.unloaded", "未加载的classes数");
        map.put("jvm.gc.memory.allocated", "GC时，年轻代分配的内存空间");
        map.put("jvm.gc.memory.promoted", "GC时，老年代分配的内存空间");
        map.put("jvm.gc.max.data.size", "GC时，老年代的最大内存空间");
        map.put("jvm.gc.live.data.size", "FullGC时，老年代的内存空间");
        map.put("jvm.gc.pause", "GC耗时");
        //TOMCAT
        map.put("tomcat.sessions.created", "tomcat已创建session数");
        map.put("tomcat.sessions.expired", "tomcat已过期session数");
        map.put("tomcat.sessions.active.current", "tomcat活跃session数");
        map.put("tomcat.sessions.active.max", "tomcat最多活跃session数");
        map.put("tomcat.sessions.alive.max", "tomcat最多活跃session数");
        map.put("tomcat.sessions.alive.max.second", "tomcat最多活跃session数持续时间");
        map.put("tomcat.sessions.rejected", "超过session最大配置后，拒绝的session个数");
        map.put("tomcat.global.error", "错误总数");
        map.put("tomcat.global.sent", "发送的字节数");
        map.put("tomcat.global.request.max", "request最长时间");
        map.put("tomcat.global.request", "全局request次数和时间");
        map.put("tomcat.global.received", "全局received次数和时间");
        map.put("tomcat.servlet.request", "servlet的请求次数和时间");
        map.put("tomcat.servlet.error", "servlet发生错误总数");
        map.put("tomcat.servlet.request.max", "servlet请求最长时间");
        map.put("tomcat.threads.busy", "tomcat繁忙线程");
        map.put("tomcat.threads.current", "tomcat当前线程数（包括守护线程）");
        map.put("tomcat.threads.config.max", "tomcat配置的线程最大数");
        map.put("tomcat.cache.access", "tomcat读取缓存次数");
        map.put("tomcat.cache.hit", "tomcat缓存命中次数");
        //CPU
        map.put("system.cpu.count", "CPU数量");
        map.put("system.load.average.1m", "load average");
        map.put("system.cpu.usage", "系统CPU使用率");
        map.put("process.cpu.usage", "当前进程CPU使用率");
        map.put("http.server.requests", "http请求调用情况");
        map.put("process.uptime", "应用已运行时间");
        map.put("process.files.max", "允许最大句柄数");
        map.put("process.start.time", "应用启动时间点");
        map.put("process.files.open", "当前打开句柄数");
    }

    private String key;
    private String value;
    private String description;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
        this.description = map.get(this.key);
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "RedisInfo{" + "key='" + key + '\'' + ", value='" + value + '\'' + ", desctiption='" + description + '\'' + '}';
    }
}
