package com.artfess.portal.kh.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.util.List;

/**
 * 考核方案信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Data
@ApiModel(value="KhScheme对象", description="考核方案信息")
public class KhScheme extends AutoFillModel<KhScheme> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请输入方案名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "方案名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "考核周期 【字典】（W：周，M：月，Q：季度，Y：年）")
    @TableField("period_")
    private String period;

    @ApiModelProperty(value = "方案状态【字典】(-1：废弃，0:草稿，1：正式)")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "方案备注")
    @TableField("memo_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "创建人单位")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;


    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "考核方案指标信息")
    @TableField(exist = false)
    private List<KhSchemeIndicators> schemeIndicatorsList;
}
