/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.api.impl.context;

import com.artfess.base.annotation.IgnoreOnAssembly;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import java.util.List;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@IgnoreOnAssembly
@Primary
public class UcimplContext
implements BaseContext,
ContextThread {
    private ThreadLocal<String> tempTenantId = new ThreadLocal();

    public void setTempTenantId(String tenantId) {
        this.tempTenantId.set(tenantId);
    }

    public void clearTempTenantId() {
        this.tempTenantId.remove();
    }

    public List<String> getCurrentAndChildOrgIds() {
        return null;
    }

    public String getCurrentUserId() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentUserId();
    }

    public String getCurrentUserAccout() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentUser().getAccount();
    }

    public String getCurrentUserName() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentUser().getFullname();
    }

    public String getCurrentOrgId() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentOrgId();
    }

    public String getCurrentOrgName() {
        if (this.authenticationEmpty()) {
            return "";
        }
        return ContextUtil.getCurrentOrgName();
    }

    public String getCurrentOrgAddvcd() {
        if (this.authenticationEmpty()) {
            return "";
        }
        return ContextUtil.getCurrentOrgAddvcd();
    }

    public String getCurrentOrgAddvcdName() {
        if (this.authenticationEmpty()) {
            return "";
        }
        return ContextUtil.getCurrentOrgAddvcdName();
    }

    public String getCurrentOrgAddvcdFull() {
        if (this.authenticationEmpty()) {
            return "";
        }
        return ContextUtil.getCurrentOrgAddvcdFull();
    }

    public String getCurrentDeptId() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentDeptId();
    }

    public String getCurrentDeptName() {
        if (this.authenticationEmpty()) {
            return "-1";
        }
        return ContextUtil.getCurrentDeptName();
    }

    public String getCurrentFullId() {
        if (this.authenticationEmpty()) {
            return "";
        }
        return ContextUtil.getCurrentOrgFullId();
    }

    public String getCurrentTenantId() {
        String tenantId = HttpUtil.getTenantId();
        if (BeanUtils.isNotEmpty((Object)tenantId)) {
            return tenantId;
        }
        String tempTenantId = this.tempTenantId.get();
        if (StringUtil.isNotEmpty((String)tempTenantId)) {
            return tempTenantId;
        }
        if (this.authenticationEmpty()) {
            return "-1";
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return "-1";
        }
        return currentUser.getTenantId();
    }

    private boolean authenticationEmpty() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return BeanUtils.isEmpty((Object)authentication) || authentication instanceof AnonymousAuthenticationToken;
    }

    public void cleanAll() {
        this.clearTempTenantId();
    }
}

