package com.artfess.ljzc.land.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * 土地资产权属信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetLandWarrents对象", description="土地资产权属信息")
public class BizAssetLandWarrents extends BizDelModel<BizAssetLandWarrents> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择土地资产", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "土地ID")
    @TableField("land_id_")
    private String landId;

    @ApiModelProperty(value = "是否获取权属信息(0：未获取1：已获取)")
    @TableField("is_get_warrents_")
    private String isGetWarrents;

    @ApiModelProperty(value = "权证号")
    @TableField("warrents_no_")
    private String warrentsNo;

    @ApiModelProperty(value = "是否设置抵押(0：否  1：是)")
    @TableField("is_mortgage_")
    private String isMortgage;

    @ApiModelProperty(value = "未获取原因")
    @TableField("warrents_reason_")
    private String warrentsReason;

    @ApiModelProperty(value = "权属单位ID")
    @TableField("warrents_org_id_")
    private String warrentsOrgId;

    @ApiModelProperty(value = "权属单位")
    @TableField("warrents_org_name_")
    private String warrentsOrgName;

}
