package com.artfess.ljzc.land.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;

/**
 * 土地资产使用信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Data
@ApiModel(value="BizAssetLandUse对象", description="土地资产使用信息")
public class BizAssetLandUse extends BizDelModel<BizAssetLandUse> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择土地资产", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "土地资产id")
    @TableField("land_id_")
    private String landId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "土地自用面积（亩）")
    @TableField("use_area_")
    private BigDecimal useArea;

    @ApiModelProperty(value = "土地出租面积（亩）")
    @TableField("hire_area_")
    private BigDecimal hireArea;

    @ApiModelProperty(value = "土地被占用面积（亩）")
    @TableField("occupy_area_")
    private BigDecimal occupyArea;

    @ApiModelProperty(value = "土地出借面积（亩）")
    @TableField("lend_area_")
    private BigDecimal lendArea;

    @ApiModelProperty(value = "土地其他面积（亩）")
    @TableField("other_area_")
    private BigDecimal otherArea;

    @ApiModelProperty(value = "土地闲置面积（亩）")
    @TableField("unused_area_")
    private BigDecimal unusedArea;

    @ApiModelProperty(value = "闲置原因")
    @TableField("unused_reason_")
    private String unusedReason;

    @ApiModelProperty(value = "出租率（%）（出租面积/土地面积）")
    @TableField("hire_rate_")
    private BigDecimal hireRate;

    @ApiModelProperty(value = "年收益（万元）")
    @TableField("year_earnings_")
    private BigDecimal yearEarnings;

    @ApiModelProperty(value = "年收益率（%）（年收益/账面净值）")
    @TableField("year_earnings_rate_")
    private BigDecimal yearEarningsRate;

    @ApiModelProperty(value = "运营分级（A,B,C,D）")
    @TableField("operation_level_")
    private String operationLevel;

    @ApiModelProperty(value = "盘活计划")
    @TableField("vitalize_plan_")
    private String vitalizePlan;

    @ApiModelProperty(value = "盘活措施")
    @TableField("vitalize_measure_")
    private String vitalizeMeasure;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

}
