package com.artfess.ljzc.fixed.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.artfess.ljzc.fixed.dao.BizAssetFixedInfoDao;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInfoManager;
import com.artfess.ljzc.fixed.manager.BizAssetFixedInventoryManager;
import com.artfess.ljzc.fixed.manager.BizAssetFixedTypeManager;
import com.artfess.ljzc.fixed.model.BizAssetFixedInfo;
import com.artfess.ljzc.fixed.model.BizAssetFixedInventory;
import com.artfess.ljzc.fixed.model.BizAssetFixedType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 固定资产信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Service
public class BizAssetFixedInfoManagerImpl extends BaseManagerImpl<BizAssetFixedInfoDao, BizAssetFixedInfo> implements BizAssetFixedInfoManager {

    @Autowired
    private BizAssetFixedInventoryManager fixedInventoryManager;

    @Autowired
    private BizAssetFixedTypeManager assetFixedTypeManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean createInfo(BizAssetFixedInfo t) {
        boolean save = this.save(t);
        if(save) {
            processInfo(t);
        }
        return save;
    }

    private void processInfo(BizAssetFixedInfo t) {
        BizAssetFixedInventory assetFixedInventory = t.getAssetFixedInventory();
        assetFixedInventory.setFixedId(t.getId());
        assetFixedInventory.setTypeId(t.getTypeId());
        fixedInventoryManager.saveOrUpdate(assetFixedInventory);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(BizAssetFixedInfo t) {
        boolean b = this.updateById(t);
        if(b) {
            processInfo(t);
        }
        return b;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeInfo(List<String> ids) {
        boolean b = this.removeByIds(ids);
        if(b) {
            QueryWrapper<BizAssetFixedInventory> warrentsQueryWrapper = new QueryWrapper<>();
            warrentsQueryWrapper.in("fixed_id_", ids);
            fixedInventoryManager.remove(warrentsQueryWrapper);

        }
        return b;
    }

    @Override
    public PageList<BizAssetFixedInfo> findByPage(QueryFilter<BizAssetFixedInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", DelStatusEnum.N.getType(), QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        Class<BizAssetFixedInfo> currentModelClass = currentModelClass();
        IPage<BizAssetFixedInfo> result = baseMapper.findByPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<BizAssetFixedInfo>(result);
    }

    @Override
    public List<JSONObject> fixedStatistics(String fullId) {
        return this.baseMapper.fixedStatistics(fullId);
    }

    @Override
    public BizAssetFixedInfo findById(String id) {
        Assert.hasText(id, "请选择要查看的资产");
        BizAssetFixedInfo businessInfo = this.get(id);
        QueryWrapper<BizAssetFixedInventory> warrentsQueryWrapper = new QueryWrapper<>();
        warrentsQueryWrapper.eq("fixed_id_", id);
        BizAssetFixedInventory fixedInventory = fixedInventoryManager.getOne(warrentsQueryWrapper);
        businessInfo.setAssetFixedInventory(fixedInventory);

        BizAssetFixedType bizAssetFixedType = assetFixedTypeManager.get(businessInfo.getTypeId());
        if(null != bizAssetFixedType) {
            businessInfo.setTypeName(bizAssetFixedType.getName());
        }
        return businessInfo;
    }

}
