/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.persistence.manager.impl;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.attachment.AttachmentServiceFactory;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.file.attachmentService.FtpAttachmentServiceImpl;
import com.artfess.file.config.UploadResult;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.dao.FileDao;
import com.artfess.file.persistence.manager.FileConfigManager;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.AppFileUtil;
import com.artfess.file.vo.FileReqVo;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="fileManager")
public class FileManagerImpl
extends BaseManagerImpl<FileDao, DefaultFile>
implements FileManager {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    IUserService userService;
    @Resource
    BaseContext baseContext;
    @Resource
    FileConfigManager fileConfigManager;
    @Resource
    private FileDao fileDao;
    private AttachmentService attachmentService;

    private void initCurrentHandler(String propertiesId) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(AppFileUtil.getSaveType(propertiesId));
    }

    private void initCurrentHandlerByBizCode(String bizCode) throws Exception {
        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
        this.attachmentService = attachmentHandlerFactory.getCurrentServices(AppFileUtil.getFileSaveTypeByConfig(bizCode));
    }

    @Override
    public List<DefaultFile> getAllByExt(String[] allowFiles) {
        return ((FileDao)this.baseMapper).getAllByExt(allowFiles);
    }

    @Override
    public void updateFileBizIdByIds(List<String> idList, String bizId) {
        this.removeFileByBizId(bizId);
        this.fileDao.updateFileDelAndBizIdByIds("0", bizId, null, idList);
    }

    @Override
    public void updateFileBizIdByIds(List<String> idList, String bizId, String bizCode) {
        this.removeFileByBizId(bizId);
        this.fileDao.updateFileDelAndBizIdByIds("0", bizId, bizCode, idList);
    }

    @Override
    public void removeFileByBizId(String bizId) {
        UpdateWrapper deleOldFileUpdateWrapper = new UpdateWrapper();
        ((UpdateWrapper)deleOldFileUpdateWrapper.set((Object)"IS_DEL_", (Object)"1")).eq((Object)"BIZ_ID_", (Object)bizId);
        this.update((Wrapper)deleOldFileUpdateWrapper);
    }

    @Override
    public List<DefaultFile> queryFileByBizId(String bizId) {
        QueryWrapper defaultFileQueryWrapper = new QueryWrapper();
        ((QueryWrapper)defaultFileQueryWrapper.eq((Object)"BIZ_ID_", (Object)bizId)).eq((Object)"is_del_", (Object)0);
        return this.list((Wrapper)defaultFileQueryWrapper);
    }

    @Override
    public List<DefaultFile> queryFileByBizId(String bizId, String bizCode) {
        QueryWrapper defaultFileQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)defaultFileQueryWrapper.eq((Object)"BIZ_ID_", (Object)bizId)).eq((Object)"is_del_", (Object)0)).eq((Object)"BIZ_CODE_", (Object)bizCode);
        return this.list((Wrapper)defaultFileQueryWrapper);
    }

    @Override
    @Transactional
    public void delSysFileByIds(String[] ids) throws Exception {
        DefaultFile file;
        String propertiesId = "";
        if (BeanUtils.isNotEmpty((Object)ids) && ids.length > 0 && BeanUtils.isNotEmpty((Object)((Object)(file = this.get((Serializable)((Object)ids[0])))))) {
            propertiesId = file.getProp6();
        }
        this.initCurrentHandler(propertiesId);
        for (String id : ids) {
            DefaultFile def;
            this.attachmentService.remove((Attachment)def, BeanUtils.isNotEmpty((Object)((Object)(def = this.get((Serializable)((Object)id))))) ? def.getProp6() : "");
            ((FileDao)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public UploadResult UploadFileForConfig(DefaultFile file, List<MultipartFile> files, String bizCode, String bizId, String bizType, IUser currentUser) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        this.initCurrentHandlerByBizCode(bizCode);
        FileStorageConfigDTO fileStorageConfig = this.fileConfigManager.getFileConfigByCode(bizCode);
        String fileFormates = fileStorageConfig.getFileKinds();
        Double allowSize = fileStorageConfig.getAllowSize();
        int allowMultiple = fileStorageConfig.getAllowMultiple();
        UploadResult result = new UploadResult();
        if (allowMultiple == 0 && files.size() > 1) {
            result.setSuccess(false);
            result.setMessage("\u7cfb\u7edf\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u9644\u4ef6\uff01");
            return result;
        }
        short isdel = 0;
        while (it.hasNext()) {
            long len;
            double fileSize;
            DefaultFile sysFile;
            Boolean isAdd = false;
            String oldFilePath = "";
            if (StringUtil.isNotEmpty((String)file.getId())) {
                sysFile = this.get((Serializable)((Object)file.getId()));
                oldFilePath = sysFile.getFilePath();
            } else {
                isAdd = true;
                sysFile = new DefaultFile();
                sysFile.setId(UniqueIdUtil.getSuid());
            }
            MultipartFile f = it.next();
            if (StringUtil.isNotEmpty((String)file.getFileName()) && !file.getFileName().equals(f.getName())) {
                throw new RuntimeException("\u4e0a\u4f20\u540d\u79f0\u4e0e\u6587\u4ef6\u540d\u79f0\u4e0d\u7b26");
            }
            String oriFileName = f.getOriginalFilename();
            String extName = FileUtil.getFileExt((String)oriFileName);
            if (StringUtil.isNotEmpty((String)fileFormates)) {
                List<String> typeList = Arrays.asList(fileFormates.split(","));
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!StringUtil.isNotEmpty((String)typeList.get(i))) continue;
                    typeList.set(i, typeList.get(i).toLowerCase());
                }
                if (typeList.indexOf(extName) < 0 && typeList.indexOf("." + extName) < 0) {
                    result.setSuccess(false);
                    result.setMessage("\u7cfb\u7edf\u4e0d\u5141\u8bb8\u8be5\u7c7b\u578b\u6587\u4ef6\u7684\u4e0a\u4f20\uff01:" + extName);
                    return result;
                }
            }
            if (allowSize != null && allowSize > 0.0 && (fileSize = (double)(len = f.getSize()) / 1048576.0) > allowSize) {
                result.setSuccess(false);
                result.setMessage("\u4e0a\u4f20\u6587\u4ef6\u3010" + oriFileName + "\u3011\u5927\u5c0f\u5df2\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236\uff1a" + fileSize + "MB\uff01");
                return result;
            }
            String fileName = sysFile.getId() + "." + extName;
            String filePath = "";
            String creatorAccount = DefaultFile.FILE_UPLOAD_UNKNOWN;
            if (currentUser != null) {
                sysFile.setCreateBy(currentUser.getUserId());
                sysFile.setCreatorName(currentUser.getFullname());
                creatorAccount = currentUser.getAccount();
            } else {
                sysFile.setCreatorName(creatorAccount);
            }
            filePath = "pictureShow".equals(sysFile.getFileType()) ? AppFileUtil.createFilePath(creatorAccount + File.separator + "pictureShow", fileName) : AppFileUtil.createFilePath(currentUser.getAccount(), fileName);
            sysFile.setFileName(oriFileName.lastIndexOf(46) == -1 ? oriFileName : oriFileName.substring(0, oriFileName.lastIndexOf(46)));
            sysFile.setFilePath(filePath);
            sysFile.setBizCode(bizCode);
            sysFile.setBizId(bizId);
            sysFile.setBizType(bizType);
            sysFile.setIsZone(0);
            sysFile.setZoneTotal(1);
            sysFile.setMd5Value(DigestUtils.md5DigestAsHex((InputStream)f.getInputStream()));
            sysFile.setServerLocalName(fileName);
            String rootPath = SysPropertyUtil.getByAlias((String)"file.upload");
            sysFile.setServerLocalPath(rootPath + filePath);
            sysFile.setCreateTime(LocalDateTime.now());
            sysFile.setExtensionName(extName);
            sysFile.setByteCount(f.getSize());
            sysFile.setIsDel(isdel);
            sysFile.setNote(FileUtil.getSize((double)f.getSize()));
            sysFile.setProp6(fileStorageConfig.getStorageId());
            sysFile.setStoreType(fileStorageConfig.getUploadType());
            if (isAdd.booleanValue()) {
                sysFile.setBytes(f.getBytes());
                this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                if (!fileStorageConfig.getUploadType().equals(DefaultFile.SAVE_TYPE_DTABASE)) {
                    sysFile.setBytes(null);
                }
                super.create((Model)sysFile);
            } else {
                this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                this.update((Model)sysFile);
                boolean tag = true;
                String newFilePath = sysFile.getFilePath();
                if (StringUtil.isNotEmpty((String)newFilePath) && StringUtil.isNotEmpty((String)oldFilePath) && newFilePath.trim().equals(oldFilePath.trim())) {
                    tag = false;
                }
                if (tag) {
                    sysFile.setFilePath(oldFilePath);
                    this.attachmentService.remove((Attachment)sysFile, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                }
            }
            result.setSuccess(true);
            result.setFileId(sysFile.getId());
            result.setFileName(oriFileName);
            result.setSize(sysFile.getByteCount());
            result.setUsername(sysFile.getCreatorName());
        }
        return result;
    }

    @Override
    @Transactional
    public UploadResult uploadFile(DefaultFile file, List<MultipartFile> files, String fileFormates, IUser currentUser, String flowKey) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        this.initCurrentHandler(flowKey);
        UploadResult result = new UploadResult();
        boolean mark = true;
        short isdel = 0;
        while (it.hasNext()) {
            DefaultFile sysFile;
            Boolean isAdd = false;
            String oldFilePath = "";
            if (StringUtil.isNotEmpty((String)file.getId())) {
                sysFile = this.get((Serializable)((Object)file.getId()));
                oldFilePath = sysFile.getFilePath();
            } else {
                isAdd = true;
                sysFile = new DefaultFile();
                sysFile.setId(UniqueIdUtil.getSuid());
            }
            MultipartFile f = it.next();
            if (StringUtil.isNotEmpty((String)file.getFileName()) && !file.getFileName().equals(f.getName())) {
                throw new RuntimeException("\u4e0a\u4f20\u540d\u79f0\u4e0e\u6587\u4ef6\u540d\u79f0\u4e0d\u7b26");
            }
            String oriFileName = f.getOriginalFilename();
            String extName = FileUtil.getFileExt((String)oriFileName);
            if (StringUtil.isNotEmpty((String)fileFormates)) {
                List<String> typeList = Arrays.asList(fileFormates.split(","));
                for (int i = 0; i < typeList.size(); ++i) {
                    if (!StringUtil.isNotEmpty((String)typeList.get(i))) continue;
                    typeList.set(i, typeList.get(i).toLowerCase());
                }
                if (typeList.indexOf(extName) < 0 && typeList.indexOf("." + extName) < 0) {
                    mark = false;
                }
            }
            if (mark) {
                FlowUploadPropertiesManager uploadPropertiesManager;
                FlowUploadPropertiesStorageDTO uploadProperties;
                String fileName = sysFile.getId() + "." + extName;
                String filePath = "";
                String creatorAccount = DefaultFile.FILE_UPLOAD_UNKNOWN;
                if (currentUser != null) {
                    sysFile.setCreateBy(currentUser.getUserId());
                    sysFile.setCreatorName(currentUser.getFullname());
                    creatorAccount = currentUser.getAccount();
                } else {
                    sysFile.setCreatorName(creatorAccount);
                }
                filePath = "pictureShow".equals(sysFile.getFileType()) ? AppFileUtil.createFilePath(creatorAccount + File.separator + "pictureShow", fileName) : AppFileUtil.createFilePath(currentUser.getAccount(), fileName);
                sysFile.setFileName(oriFileName.lastIndexOf(46) == -1 ? oriFileName : oriFileName.substring(0, oriFileName.lastIndexOf(46)));
                sysFile.setFilePath(filePath);
                sysFile.setCreateTime(LocalDateTime.now());
                sysFile.setExtensionName(extName);
                sysFile.setByteCount(f.getSize());
                sysFile.setIsDel(isdel);
                sysFile.setNote(FileUtil.getSize((double)f.getSize()));
                if (StringUtil.isNotEmpty((String)flowKey) && BeanUtils.isNotEmpty((Object)(uploadProperties = (uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class)).getByFlowKey(flowKey)))) {
                    sysFile.setProp6(uploadProperties.getId());
                }
                String saveType = AppFileUtil.getSaveType(flowKey);
                sysFile.setStoreType(saveType);
                if (isAdd.booleanValue()) {
                    sysFile.setBytes(f.getBytes());
                    this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    if (!saveType.equals(DefaultFile.SAVE_TYPE_DTABASE)) {
                        sysFile.setBytes(null);
                    }
                    super.create((Model)sysFile);
                } else {
                    this.attachmentService.upload((Attachment)sysFile, f.getInputStream(), BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    this.update((Model)sysFile);
                    boolean tag = true;
                    String newFilePath = sysFile.getFilePath();
                    if (StringUtil.isNotEmpty((String)newFilePath) && StringUtil.isNotEmpty((String)oldFilePath) && newFilePath.trim().equals(oldFilePath.trim())) {
                        tag = false;
                    }
                    if (tag) {
                        sysFile.setFilePath(oldFilePath);
                        this.attachmentService.remove((Attachment)sysFile, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
                    }
                }
                result.setSuccess(true);
                result.setFileId(sysFile.getId());
                result.setFileName(oriFileName);
                result.setSize(sysFile.getByteCount());
                result.setUsername(sysFile.getCreatorName());
                continue;
            }
            result.setSuccess(false);
            result.setMessage("\u7cfb\u7edf\u4e0d\u5141\u8bb8\u8be5\u7c7b\u578b\u6587\u4ef6\u7684\u4e0a\u4f20\uff01:" + extName);
        }
        return result;
    }

    @Override
    public DefaultFile downloadFile(String fileId, OutputStream outStream) throws Exception {
        DefaultFile sysFile = this.get((Serializable)((Object)fileId));
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        if (this.attachmentService instanceof FtpAttachmentServiceImpl && DefaultFile.SAVE_TYPE_FOLDER.equals(sysFile.getStoreType())) {
            AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
            this.attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_FOLDER);
        }
        this.attachmentService.download((Attachment)sysFile, outStream, BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        return sysFile;
    }

    @Override
    @Transactional
    public void uploadFile(DefaultFile file, InputStream inputStream) throws Exception {
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        String storeType = file.getStoreType();
        if (StringUtil.isEmpty((String)file.getId())) {
            file.setId(UniqueIdUtil.getSuid());
        }
        this.attachmentService.upload((Attachment)file, inputStream, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        if (StringUtil.isEmpty((String)storeType)) {
            storeType = AppFileUtil.getSaveType(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
            file.setStoreType(storeType);
        }
        if (!DefaultFile.SAVE_TYPE_DTABASE.equals(storeType)) {
            file.setBytes(null);
        }
        super.create((Model)file);
    }

    @Override
    @Transactional
    public void setXbTypeId(List<String> fileId, String xbTypeId, String type) throws Exception {
        ((FileDao)this.baseMapper).setXbTypeId(fileId, xbTypeId, type);
    }

    @Override
    @Transactional
    public void updateFileExtraProp(List<DefaultFile> files) {
        if (BeanUtils.isNotEmpty(files)) {
            for (DefaultFile defaultFile : files) {
                ((FileDao)this.baseMapper).updateExtraProps(defaultFile);
            }
        }
    }

    @Override
    public byte[] getFileBytesById(String fileId) throws Exception {
        DefaultFile sysFile = this.get((Serializable)((Object)fileId));
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)sysFile)) ? sysFile.getProp6() : "");
        if (BeanUtils.isEmpty((Object)((Object)sysFile))) {
            return null;
        }
        return this.attachmentService.getFileBytes((Attachment)sysFile);
    }

    public DefaultFile get(Serializable id) {
        DefaultFile file = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            file = (DefaultFile)super.get(id);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    @Override
    public void downloadFileToPath(DefaultFile file, String path) throws Exception {
        this.initCurrentHandler(BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
        File dfile = new File(path);
        if (!dfile.exists()) {
            if (BeanUtils.isNotEmpty((Object)dfile.getParentFile()) && !dfile.getParentFile().exists()) {
                dfile.getParentFile().mkdir();
            }
            FileOutputStream out = new FileOutputStream(dfile);
            this.attachmentService.download((Attachment)file, (OutputStream)out, BeanUtils.isNotEmpty((Object)((Object)file)) ? file.getProp6() : "");
            out.flush();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importSignature(MultipartFile file, boolean isCover) {
        String rootRealPath = "";
        CommonResult message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f\uff01");
        try {
            String unZipDir = TimeUtil.getCurrentTimeMillis() + "_" + this.baseContext.getCurrentUserId();
            rootRealPath = (FileUtil.getIoTmpdir() + "attachFiles/unZip/" + unZipDir).replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            File ignatureFloder = new File(rootRealPath);
            File[] fs = ignatureFloder.listFiles();
            IUser user = null;
            String account = this.baseContext.getCurrentUserAccout();
            if (StringUtil.isNotEmpty((String)account)) {
                user = this.userService.getUserByAccount(account);
            }
            ArrayNode accountFiles = JsonUtil.getMapper().createArrayNode();
            ExecutorService pool = Executors.newFixedThreadPool(fs.length);
            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
            ArrayList<Future<Object>> list = new ArrayList<Future<Object>>();
            for (File signatureFile : fs) {
                if (signatureFile.isDirectory() || !signatureFile.getName().endsWith(".png")) continue;
                MyCallable c = new MyCallable(signatureFile, user, fileManager);
                Future<Object> f = pool.submit(c);
                list.add(f);
            }
            for (Future future : list) {
                UploadResult result = (UploadResult)future.get();
                if (!result.isSuccess()) continue;
                ObjectNode accountFile = JsonUtil.getMapper().createObjectNode();
                String[] names = result.getFileName().split("\\.");
                accountFile.put("account", names[0]);
                accountFile.put("fileId", result.getFileId());
                accountFiles.add((JsonNode)accountFile);
            }
            if (accountFiles.size() > 0) {
                ObjectNode signatureData = JsonUtil.getMapper().createObjectNode();
                signatureData.put("repeatConver", isCover);
                signatureData.set("signatureList", (JsonNode)accountFiles);
                CommonResult commonResult = this.ucFeignService.saveSignatureBatch(signatureData);
                if (!commonResult.getState().booleanValue()) {
                    String[] ids = new String[signatureData.size()];
                    for (int i = 0; i < accountFiles.size(); ++i) {
                        ids[i] = accountFiles.get(i).get("fileId").asText();
                    }
                    this.delSysFileByIds(ids);
                    CommonResult commonResult2 = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + commonResult.getMessage());
                    return commonResult2;
                }
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File fileDir = new File(rootRealPath);
            if (fileDir.exists()) {
                FileUtil.deleteDir((File)fileDir);
            }
        }
        return message;
    }

    @Override
    @Transactional
    public synchronized String insertFile(DefaultFile file) {
        if (BeanUtils.isNotEmpty((Object)((Object)file))) {
            DefaultFile oldFile = this.queryByMd5AndSize(file.getByteCount(), file.getMd5Value());
            if (oldFile == null) {
                ((FileDao)this.baseMapper).insert((Object)file);
                return file.getId();
            }
        } else {
            throw new RequiredException("\u9644\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return "";
    }

    @Override
    public DefaultFile queryByMd5AndSize(Long fileSize, String md5Value) {
        if (StringUtil.isEmpty((String)md5Value)) {
            throw new RequiredException("\u6587\u4ef6hash\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (BeanUtils.isEmpty((Object)fileSize)) {
            throw new RequiredException("\u6587\u4ef6\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"md5_value_", (Object)md5Value)).eq((Object)"byte_count_", (Object)fileSize);
        List list = ((FileDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                return (DefaultFile)((Object)list.get(0));
            }
            throw new ApplicationException("\u6709\u6587\u4ef6hash\u503c\u91cd\u590d\u7684\u6587\u4ef6\uff01");
        }
        return null;
    }

    @Override
    public DefaultFile getFileInfo(FileReqVo fileReqVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FILE_TYPE_", (Object)fileReqVo.getFileType());
        queryWrapper.eq((Object)"BIZ_ID_", (Object)fileReqVo.getBizId());
        DefaultFile defaultFile = (DefaultFile)((Object)((FileDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return defaultFile;
    }

    class MyCallable
    implements Callable<Object> {
        private Logger logger = LoggerFactory.getLogger(FileManagerImpl.class);
        private File file;
        private IUser user;
        private FileManager fileManager;

        MyCallable(File file, IUser user, FileManager fileManager) {
            this.file = file;
            this.user = user;
            this.fileManager = fileManager;
        }

        @Override
        public Object call() throws Exception {
            this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20");
            LocalDateTime dateTmp1 = LocalDateTime.now();
            UploadResult result = this.upload();
            Thread.sleep(200L);
            LocalDateTime dateTmp2 = LocalDateTime.now();
            long time = TimeUtil.getTimeMillis((LocalDateTime)dateTmp2) - TimeUtil.getTimeMillis((LocalDateTime)dateTmp1);
            this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20\u5b8c\u6210; \u82b1\u8d39\u65f6\u95f4\u4e3a\uff1a " + time);
            return result;
        }

        private UploadResult upload() {
            try {
                FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
                MultipartFile multipartFile = FileUtil.fileToMultipartFile((File)this.file);
                ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
                files.add(multipartFile);
                DefaultFile file = new DefaultFile();
                return fileManager.uploadFile(file, files, null, this.user, "");
            }
            catch (Exception e) {
                this.logger.info(">>>" + this.file.getName() + "\u7b7e\u7ae0\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a " + e.getMessage());
                return null;
            }
        }
    }
}

