/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.aop;

import com.artfess.base.annotation.Workflow;
import com.artfess.base.entity.BaseModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WorkflowAspect {
    @Resource
    WorkflowFeignService workflowFeignService;

    @Around(value="execution(* *..*Controller.*(..)) && @annotation(com.artfess.base.annotation.Workflow)")
    public Object workflow(ProceedingJoinPoint joinPoint) throws Throwable {
        ObjectNode startFlowResult;
        int i;
        Object returnVal = null;
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Object[] params = joinPoint.getArgs();
        Method[] methods = targetClass.getMethods();
        Method method = null;
        BaseModel param = null;
        for (i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof BaseModel)) continue;
            param = (BaseModel)((Object)params[i]);
            break;
        }
        if (BeanUtils.isEmpty(param)) {
            returnVal = joinPoint.proceed();
            return returnVal;
        }
        for (i = 0; i < methods.length; ++i) {
            if (methods[i].getName() != methodName) continue;
            method = methods[i];
            break;
        }
        Workflow workflow = method.getAnnotation(Workflow.class);
        String flowKey = workflow.flowKey();
        String sysCode = workflow.sysCode();
        String instanceIdField = workflow.instanceIdField();
        String[] varKeys = workflow.varKeys();
        if (StringUtil.isEmpty(flowKey)) {
            return joinPoint.proceed();
        }
        ObjectNode startFlowParam = JsonUtil.getMapper().createObjectNode();
        startFlowParam.put("flowKey", flowKey);
        String businessKey = param.getPkVal();
        if (StringUtil.isEmpty(businessKey)) {
            throw new WorkFlowException("\u542f\u52a8\u6d41\u7a0b\u65f6\uff0c\u5b9e\u4f53\u5bf9\u8c61\u4e2d\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        startFlowParam.put("businessKey", businessKey);
        startFlowParam.put("formType", "frame");
        if (StringUtil.isNotEmpty(sysCode)) {
            startFlowParam.put("sysCode", sysCode);
        }
        if (BeanUtils.isNotEmpty(varKeys) && varKeys.length > 0) {
            ObjectNode varsObject = JsonUtil.getMapper().createObjectNode();
            JsonNode paramJsonNode = JsonUtil.toJsonNode((Object)param);
            for (String key : varKeys) {
                JsonNode jsonNode = paramJsonNode.get(key);
                varsObject.set(key, jsonNode);
            }
            startFlowParam.set("vars", (JsonNode)varsObject);
        }
        if (!BeanUtils.isNotEmpty(startFlowResult = this.workflowFeignService.start(startFlowParam)) || !startFlowResult.get("state").asBoolean()) {
            String message = "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25";
            if (BeanUtils.isNotEmpty(startFlowResult) && BeanUtils.isNotEmpty(startFlowResult.get("message"))) {
                message = message + ":" + startFlowResult.get("message").asText();
            }
            throw new BaseException(message);
        }
        String instanceId = startFlowResult.get("instId").asText();
        BeanUtils.setProperty((Object)param, instanceIdField, instanceId);
        returnVal = joinPoint.proceed();
        return returnVal;
    }
}

