/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ljzc.land.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.ljzc.land.dao.BizAssetLandInfoDao;
import com.artfess.ljzc.land.manager.BizAssetLandInfoManager;
import com.artfess.ljzc.land.manager.BizAssetLandUseManager;
import com.artfess.ljzc.land.manager.BizAssetLandWarrentsManager;
import com.artfess.ljzc.land.model.BizAssetLandInfo;
import com.artfess.ljzc.land.model.BizAssetLandUse;
import com.artfess.ljzc.land.model.BizAssetLandWarrents;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizAssetLandInfoManagerImpl
extends BaseManagerImpl<BizAssetLandInfoDao, BizAssetLandInfo>
implements BizAssetLandInfoManager {
    @Autowired
    private BizAssetLandUseManager assetLandUseManager;
    @Autowired
    private BizAssetLandWarrentsManager assetLandWarrentsManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean audit(List<String> ids, String status, String assetMsg) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5ba1\u6838\u7684\u8d44\u4ea7");
        Assert.hasText((String)status, (String)"\u8bf7\u9009\u62e9\u5ba1\u6838\u72b6\u6001");
        List list = this.listByIds(ids);
        Assert.notEmpty((Collection)list, (String)"\u8d44\u4ea7\u4fe1\u606f\u4e0d\u5b58\u5728");
        list.forEach(info -> {
            info.setAssetAudit(status);
            info.setAssetMsg(assetMsg);
        });
        boolean b = this.updateBatchById(list);
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(BizAssetLandInfo t) {
        boolean save = this.save((Object)t);
        if (save) {
            this.processInfo(t);
        }
        return save;
    }

    @Override
    public PageList<BizAssetLandInfo> findByPage(QueryFilter<BizAssetLandInfo> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)DelStatusEnum.N.getType(), QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<BizAssetLandInfo> result = ((BizAssetLandInfoDao)this.baseMapper).findByPage((IPage<BizAssetLandInfo>)this.convert2IPage(pageBean), (Wrapper<BizAssetLandInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public JSONObject landStatistics(String fullId) {
        JSONObject jsonObject = ((BizAssetLandInfoDao)this.baseMapper).landStatistics(fullId);
        Integer year = LocalDate.now().getYear();
        Integer lastYear = LocalDate.now().getYear() - 1;
        ArrayList yearList = Lists.newArrayList();
        yearList.add(year);
        yearList.add(lastYear);
        List<JSONObject> yearUseArea = ((BizAssetLandInfoDao)this.baseMapper).yearUseArea(fullId, yearList);
        BigDecimal thisYearUnusedArea = BigDecimal.ZERO;
        BigDecimal lastYearUnusedArea = BigDecimal.ZERO;
        for (JSONObject area : yearUseArea) {
            if (area.containsKey((Object)"year") && year.equals(area.getInteger("year"))) {
                thisYearUnusedArea = thisYearUnusedArea.add(area.getBigDecimal("unusedArea"));
            }
            if (!area.containsKey((Object)"year") || !lastYear.equals(area.getInteger("year"))) continue;
            lastYearUnusedArea = lastYearUnusedArea.add(area.getBigDecimal("unusedArea"));
        }
        String decreaseRate = null;
        decreaseRate = lastYearUnusedArea.doubleValue() == 0.0 ? "100%" : thisYearUnusedArea.subtract(lastYearUnusedArea).divide(lastYearUnusedArea, 2, 4).multiply(new BigDecimal("100")) + "%";
        jsonObject.put(year.toString(), (Object)thisYearUnusedArea);
        jsonObject.put("decreaseRate", (Object)decreaseRate);
        List<JSONObject> assetStatusList = ((BizAssetLandInfoDao)this.baseMapper).assetStatusList(fullId);
        JSONObject data = new JSONObject();
        data.put("areaInfo", (Object)jsonObject);
        data.put("bookValueInfo", assetStatusList);
        return data;
    }

    private void processInfo(BizAssetLandInfo t) {
        BizAssetLandWarrents assetLandWarrents = t.getAssetLandWarrents();
        assetLandWarrents.setLandId(t.getId());
        this.assetLandWarrentsManager.saveOrUpdate((Object)assetLandWarrents);
        BizAssetLandUse assetLandUse = t.getAssetLandUse();
        assetLandUse.setLandId(t.getId());
        this.assetLandUseManager.saveOrUpdate((Object)assetLandUse);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizAssetLandInfo t) {
        boolean b = this.updateById((Object)t);
        if (b) {
            this.processInfo(t);
        }
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeInfo(List<String> ids) {
        boolean b = this.removeByIds(ids);
        if (b) {
            QueryWrapper warrentsQueryWrapper = new QueryWrapper();
            warrentsQueryWrapper.in((Object)"land_id_", ids);
            this.assetLandWarrentsManager.remove((Wrapper)warrentsQueryWrapper);
            QueryWrapper useQueryWrapper = new QueryWrapper();
            useQueryWrapper.in((Object)"land_id_", ids);
            this.assetLandUseManager.remove((Wrapper)useQueryWrapper);
        }
        return b;
    }

    @Override
    public BizAssetLandInfo findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u8d44\u4ea7");
        BizAssetLandInfo businessInfo = (BizAssetLandInfo)this.get((Serializable)((Object)id));
        QueryWrapper warrentsQueryWrapper = new QueryWrapper();
        warrentsQueryWrapper.eq((Object)"land_id_", (Object)id);
        BizAssetLandWarrents warrents = (BizAssetLandWarrents)((Object)this.assetLandWarrentsManager.getOne((Wrapper)warrentsQueryWrapper));
        businessInfo.setAssetLandWarrents(warrents);
        QueryWrapper useQueryWrapper = new QueryWrapper();
        useQueryWrapper.eq((Object)"land_id_", (Object)id);
        BizAssetLandUse assetLandUse = (BizAssetLandUse)((Object)this.assetLandUseManager.getOne((Wrapper)useQueryWrapper));
        businessInfo.setAssetLandUse(assetLandUse);
        return businessInfo;
    }
}

