/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.persistence.dao.SysAuthUserDao;
import com.artfess.sysConfig.persistence.manager.CurrentUserService;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.sysConfig.persistence.model.SysAuthUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysAuthUserManagerImpl
extends BaseManagerImpl<SysAuthUserDao, SysAuthUser>
implements SysAuthUserManager {
    @Resource
    private CurrentUserService currentUserService;

    @Override
    public ArrayNode getRights(String authorizeId, String objType) throws IOException {
        String ownerNameJson = "[]";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizeId", authorizeId);
        params.put("objType", objType);
        List<SysAuthUser> bpmDefUsers = ((SysAuthUserDao)this.baseMapper).getAll(params);
        ownerNameJson = this.toOwnerNameJson(bpmDefUsers);
        return (ArrayNode)JsonUtil.toJsonNode((String)ownerNameJson);
    }

    @Override
    public void saveRights(String authorizeId, String objType, String ownerNameJson) throws IOException {
        if (StringUtil.isNotEmpty((String)ownerNameJson)) {
            ((SysAuthUserDao)this.baseMapper).delByAuthorizeId(authorizeId, objType);
            List<SysAuthUser> bpmDefUserList = this.toBpmDefUserList(ownerNameJson, authorizeId);
            for (SysAuthUser bpmDefUser : bpmDefUserList) {
                bpmDefUser.setObjType(objType);
                this.create((Model)bpmDefUser);
            }
        }
    }

    @Override
    public void batchSaveRights(List<String> ids, String objType, String ownerNameJson) throws IOException {
        for (String id : ids) {
            this.saveRights(id, objType, ownerNameJson);
        }
    }

    private List<SysAuthUser> toBpmDefUserList(String ownNameJson, String authorizeId) throws IOException {
        ArrayList<SysAuthUser> userList = new ArrayList<SysAuthUser>();
        if (StringUtil.isEmpty((String)ownNameJson)) {
            return userList;
        }
        ArrayNode aryJson = (ArrayNode)JsonUtil.toJsonNode((String)ownNameJson);
        for (Object obj : aryJson) {
            ObjectNode jsonObject = (ObjectNode)obj;
            List<SysAuthUser> list = this.getList(jsonObject, authorizeId);
            userList.addAll(list);
        }
        return userList;
    }

    private List<SysAuthUser> getList(ObjectNode json, String authorizeId) {
        ArrayList<SysAuthUser> bpmDefUsers = new ArrayList<SysAuthUser>();
        String type = json.get("type").asText();
        if ("everyone".equals(type)) {
            SysAuthUser defUser = new SysAuthUser();
            defUser.setId(UniqueIdUtil.getSuid());
            defUser.setAuthorizeId(authorizeId);
            defUser.setRightType(type);
            bpmDefUsers.add(defUser);
        } else {
            String ids = json.get("id").asText();
            String names = json.get("name").asText();
            String[] aryId = ids.split(",");
            String[] aryName = names.split(",");
            for (int i = 0; i < aryId.length; ++i) {
                SysAuthUser defUser = new SysAuthUser();
                defUser.setId(UniqueIdUtil.getSuid());
                defUser.setAuthorizeId(authorizeId);
                defUser.setRightType(type);
                defUser.setOwnerId(aryId[i]);
                defUser.setOwnerName(aryName[i]);
                bpmDefUsers.add(defUser);
            }
        }
        return bpmDefUsers;
    }

    private String toOwnerNameJson(List<SysAuthUser> bpmDefUsers) {
        if (BeanUtils.isEmpty(bpmDefUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map<String, String> userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (SysAuthUser user : bpmDefUsers) {
            List<SysAuthUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode ArrayNode2 = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<SysAuthUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            ArrayNode2.add((JsonNode)json);
        }
        return ArrayNode2.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<SysAuthUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<SysAuthUser> list = entry.getValue();
        String ids = "";
        String names = "";
        for (int i = 0; i < list.size(); ++i) {
            SysAuthUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
                continue;
            }
            ids = ids + "," + user.getOwnerId();
            names = names + "," + user.getOwnerName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        return jsonObj;
    }

    @Override
    public List<String> getAuthorizeIdsByUserMap(String objType) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((SysAuthUserDao)this.baseMapper).getAuthorizeIdsByUserMap(userRightMapStr, objType);
        return list;
    }

    @Override
    public boolean hasRights(String authorizeId) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((SysAuthUserDao)this.baseMapper).getAuthByAuthorizeId(userRightMapStr, authorizeId);
        return BeanUtils.isNotEmpty(list);
    }

    @Override
    @CacheEvict(value={"bpm:sys:userMenu"}, key="#userId")
    public void delUserMenuCache(String userId) {
    }

    @Override
    public boolean getAuthorizeAppMenuId(String menuId, Map<String, String> userRightMap) {
        List<String> list = ((SysAuthUserDao)this.baseMapper).getAuthorizeAppMenuId(menuId, userRightMap);
        return BeanUtils.isNotEmpty(list);
    }

    @Override
    public List<String> filterAuth(List<String> ids) {
        if (BeanUtils.isEmpty(ids)) {
            return new ArrayList<String>();
        }
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append("'");
            sb.append(ids.get(i));
            sb.append("'");
            if (i == ids.size() - 1) continue;
            sb.append(",");
        }
        List<String> res = ((SysAuthUserDao)this.baseMapper).getAuthByAuthorizedIds(userRightMapStr, sb.toString());
        return res;
    }

    @Override
    public void createDefault(String authorizeId) {
        SysAuthUser sysAuthUser = new SysAuthUser();
        sysAuthUser.setRightType("everyone");
        sysAuthUser.setAuthorizeId(authorizeId);
        sysAuthUser.setObjType("app");
        this.save((Object)sysAuthUser);
    }

    @Override
    public <T> List<T> getAuthItems(List<T> items, Function<T, String> function) {
        List<String> ids = items.parallelStream().map(function).collect(Collectors.toList());
        List<String> authIds = this.filterAuth(ids);
        List newApps = items.parallelStream().filter(item -> authIds.contains(function.apply(item))).collect(Collectors.toList());
        return newApps;
    }
}

