package com.artfess.bpm.persistence.model;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;



/**
 * 水印分配分类
 * <pre>
 * 描述：水印分配分类 实体对象
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-09-08 10:29:51
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@TableName("bpm_watermark_type")
@ApiModel(value = "BpmWatermarkType",description = "水印分配分类")
public class BpmWatermarkType extends BaseModel<BpmWatermarkType>{

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value="主键")
    protected String id;

    @XmlAttribute(name = "typeId")
    @TableField("TYPE_ID_")
    @ApiModelProperty(value="分类ID")
    protected String typeId;

    @XmlAttribute(name = "watermarkId")
    @TableField("WATERMARK_ID_")
    @ApiModelProperty(value="水印ID")
    protected String watermarkId;

    @XmlAttribute(name = "typeName")
    @TableField("type_name_")
    @ApiModelProperty(value="分类名称")
    protected String typeName;

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 返回 主键
     * @return
     */
    public String getId() {
        return this.id;
    }
    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    /**
     * 返回 分类ID
     * @return
     */
    public String getTypeId() {
        return this.typeId;
    }
    public void setWatermarkId(String watermarkId) {
        this.watermarkId = watermarkId;
    }

    /**
     * 返回 水印ID
     * @return
     */
    public String getWatermarkId() {
        return this.watermarkId;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", this.id)
                .append("typeId", this.typeId)
                .append("watermarkId", this.watermarkId)
                .append("typeName", this.typeName)
                .toString();
    }
}