package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 监测站类型
 */
@Getter
public enum StationTypeEnum {
    /**
     *
     */
    STATION("1", "监测站 "),

    ALARM("2", "广播站 "),

    VIDEO("3", "视频站 "),

    ;

    StationTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        StationTypeEnum[] values = values();
        for (StationTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
