package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 河流级别
 */
@Getter
public enum RvGradTypeEnum {
    ZERO("0","干流"),

    ONE("1", "一级支流"),

    TWO("2", "二级支流"),

    THREE("3", "三级支流"),

    FOUR("4", "四级支流"),

    FIVE("5", "五级支流"),

    SIX("6", "六级支流"),

    SEVEN("7", "七级支流"),

    EIGHT("8", "八级支流"),

    NINE("9", "未定级别"),


    ;

    RvGradTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        RvGradTypeEnum[] values = values();
        for (RvGradTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
