package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 河道功能
 */
@Getter
public enum RvFunctionEnum {

    XH("1", "行洪"),

    GS("2", "供水"),

    GG("3", "灌溉"),

    HY("4", "航运"),

    SL("5", "水力"),

    STHJ("6", "生态环境"),

    YY("7", "渔业"),

    FH("8", "防洪"),


    ;

    RvFunctionEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getLevel(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        RvFunctionEnum[] values = values();
        StringBuffer sb = new StringBuffer();
        String[] split = desc.split("、");
        for (RvFunctionEnum state : values) {

            for(String s : split){
                if(state.getDesc().equals(s)) {
                    sb.append(",");
                    sb.append(state.getType());
                }
            }
        }

        if(sb.length() > 0){
            return sb.substring(1);
        }
        return null;
    }
}
