package com.artfess.base.enums;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * s水库规模，大坝类型
 */
@Getter
public enum ResTypeEnum {
    /**
     * 删除
     */
    ONE("1", "小 (1) 型"),

    TWO("2", "小 (2) 型"),

    THREE("3", "中型"),


    ;

    ResTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String level){
        if(StringUtils.isEmpty(level)){
            return null;
        }
        ResTypeEnum[] values = values();
        for (ResTypeEnum state : values) {
            if (state.getType().equals(level)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
