package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 跨界类型
 */
@Getter
public enum CrOverTypeEnum {
    ZERO("0","未知"),

    ONE("1", "跨国并跨省"),

    TWO("2", "跨国"),

    THREE("3", "跨省"),

    FOUR("4", "跨市"),

    FIVE("5", "跨县"),

    SIX("6", "县界内"),

    ;

    CrOverTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        CrOverTypeEnum[] values = values();
        for (CrOverTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
