package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 河流岸别
 */
@Getter
public enum BankTypeEnum {
    BF("0", "不分"),

    ZUO("1", "左"),

    YOU("2", "右"),

    ;

    BankTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        BankTypeEnum[] values = values();
        for (BankTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
