import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    //分页查询
    queryData(data, cb) {
        req.post(portal + `/biz/customerInfo/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //添加
    addData(data, cb) {
        req.post(portal + `/biz/customerInfo/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //编辑
    editData(data, cb) {
        req.put(portal + `/biz/customerInfo/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    deleteData(ids, cb) {
        req.remove(portal + `/biz/customerInfo/v1/${ids}`).then(res => {
            cb(res.data)
        })
    },
    //根据id查询
    detailsData(id, cb) {
        req.get(portal + `/biz/customerInfo/v1/${id}`).then(res => {
            cb(res.data)
        })
    },
    //加入黑名单
    getBlack(id, cb) {
        req.get(portal + `/biz/customerInfo/v1/black/${id}`).then(res => {
            cb(res.data)
        })
    },
    //获取组织树
    getOrgTree(data, cb) {
        req.post(portal + `/api/org/v1/orgs/findByParamsOrgTree`, data).then(res => {
            cb(res.data)
        })
    },
     //当前用户下级组织树
     getUserOrgTree(id, cb) {
        req.get(portal + `/api/org/v1/orgTree/children/${id}`).then(res => {
            cb(res.data)
        })
    },
}