import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    //分页查询
    queryData(data, cb) {
        req.post(portal + `/biz/assetBusinessBuilding/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //添加
    addData(data, cb) {
        req.post(portal + `/biz/assetBusinessBuilding/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //编辑
    editData(data, cb) {
        req.put(portal + `/biz/assetBusinessBuilding/v1/`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    deleteData(ids, cb) {
        req.remove(portal + `/biz/assetBusinessBuilding/v1/${ids}`).then(res => {
            cb(res.data)
        })
    },
    //根据id查询
    detailsData(id, cb) {
        req.get(portal + `/biz/assetBusinessBuilding/v1/${id}`).then(res => {
            cb(res.data)
        })
    },
    //获取组织树
    getOrgTree(data, cb) {
        req.post(portal + `/api/org/v1/orgs/findByParamsOrgTree`, data).then(res => {
            cb(res.data)
        })
    },
    //当前用户下级组织树
    getUserOrgTree(id, cb) {
        req.get(portal + `/api/org/v1/orgTree/children/${id}`).then(res => {
            cb(res.data)
        })
    },
    //获取行政区划
    fullTree(data, cb) {
        req.post(portal + `/sys/sysAreas/v1/tree`,data).then(res => {
            cb(res.data)
        })
    },
    //项目信息查询
    projectQquery(data, cb) {
        req.post(portal + `/biz/assetBusinessProject/v1/query`, data).then(res => {
            cb(res.data)
        })
    },
    //获取组织经营性资产项目树
    getOrgProjectTree(data, cb) {
        req.get(portal + `/biz/assetBusinessProject/v1/orgTree`,data).then(res => {
            cb(res.data)
        })
    },
}