import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    //查询股权关系图谱
    queryData(data, cb) {
        req.post(portal + `/biz/stock/stockInfo/v1/queryStockStructures?orgId=${data.orgId}&orgName=${data.orgName}`,).then(res => {
            cb(res.data)
        })
    },
    //获取组织树
    getOrgTree(data, cb) {
        req.post(portal + `/api/org/v1/orgs/findByParamsOrgTree`, data).then(res => {
            cb(res.data)
        })
    },
     //当前用户下级组织树
     getUserOrgTree(id, cb) {
        req.get(portal + `/api/org/v1/orgTree/children/${id}`).then(res => {
            cb(res.data)
        })
    },
}