package com.artfess.uc.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.uc.dao.BizUserExtendDao;
import com.artfess.uc.manager.BizUserExtendManager;
import com.artfess.uc.model.BizUserExtend;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 用户信息扩展表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-09-13
 */
@Service
public class BizUserExtendManagerImpl extends BaseManagerImpl<BizUserExtendDao, BizUserExtend> implements BizUserExtendManager {

    @Resource
    private BaseContext baseContext;

    @Override
    public Boolean getUserExtendIsExist() {
        String userId = baseContext.getCurrentUserId();
        LambdaQueryWrapper<BizUserExtend> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizUserExtend::getUserId, userId);
        return this.count(queryWrapper) > 0;
    }
}
