package com.artfess.uc.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.uc.dto.UserApprovalRecordDTO;
import com.artfess.uc.model.BizUserApprovalRecord;
import com.artfess.base.manager.BaseManager;
import com.artfess.uc.vo.UserApprovalRecordVO;

import java.util.List;

/**
 * 用户注册审核记录表 服务类
 *
 * @author 系统管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2025-02-11
 */
public interface BizUserApprovalRecordManager extends BaseManager<BizUserApprovalRecord> {

    /**
     * 审核操作
     *
     * @param dto 审核记录DTO
     */
    void todo(UserApprovalRecordDTO dto);

    /**
     * 查询审核日志
     *
     * @param userId 用户ID
     * @return 审核日志记录VO
     */
    CommonResult<List<UserApprovalRecordVO>> getRecordByUserId(String userId);

}
