package com.artfess.uc.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.uc.dto.UserApprovalRecordDTO;
import com.artfess.uc.vo.UserApprovalRecordVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.uc.model.BizUserApprovalRecord;
import com.artfess.uc.manager.BizUserApprovalRecordManager;

import java.util.List;

/**
 * 用户注册审核记录表 前端控制器
 *
 * @author 系统管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2025-02-11
 */
@RestController
@RequestMapping("/bizUserApprovalRecord/v1/")
@Api(tags = "用户注册审核记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_UC})
public class BizUserApprovalRecordController extends BaseController<BizUserApprovalRecordManager, BizUserApprovalRecord> {

    @PostMapping("todo")
    @ApiOperation("审核操作")
    public CommonResult<String> todo(@ApiParam(name = "审核记录DTO", value = "审核记录") @RequestBody UserApprovalRecordDTO dto) {
        baseService.todo(dto);
        return new CommonResult<>(true, "操作成功");
    }

    @GetMapping("getRecord/{userId}")
    @ApiOperation("获取审核日志记录")
    public CommonResult<List<UserApprovalRecordVO>> getRecordByUserId(@ApiParam(name = "userId", value = "用户ID") @PathVariable String userId) {
        return baseService.getRecordByUserId(userId);
    }
}
