package com.artfess.dataAccess.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataAccess.dao.DataAccessControlDao;
import com.artfess.dataAccess.manager.DataAccessControlManager;
import com.artfess.dataAccess.model.DataAccessControl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据权限——授权 服务实现类
 *
 * @author llj
 * @since 2021-04-01
 */
@Service
public class DataAccessControlManagerImpl extends BaseManagerImpl<DataAccessControlDao, DataAccessControl> implements DataAccessControlManager {
    @Resource
    private DataAccessControlDao dao;

    @Override
    public List<DataAccessControl> queryListDataAccessDefined(String accessDefinedId) {
        Assert.hasText(accessDefinedId, "权限id不能为空");
        QueryWrapper<DataAccessControl> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("ACCESS_DEFINED_ID_", accessDefinedId);
        return this.dao.selectList(queryWrapper);
    }

    @Override
    @Transactional
    public String saveDataAccessDefined(List<DataAccessControl> list) {
        Assert.notNull(list, "权限定义不能为空！");
        //每次保存前删除数据
        if (list.size() > 0) {
            String accessDefinedId = list.get(0).getAccessDefinedId();
            this.dao.deleteByAccessDefinedId(accessDefinedId);
        }
        String msg = "";
        for (int i = 0; i < list.size(); i++) {
            this.dao.insert(list.get(i));
        }
        msg = "更新成功";
        return msg;
    }

}
