package com.artfess.base.conf;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * jwt
 * @author zhangxw
 * @Date 2020-06-08
 */
@Component
@ConfigurationProperties(prefix = "jwt")
public class JwtConfig {
	/**
	 * 头部key
	 */
	private String header;
	/**
	 * 密钥
	 */
	private String secret;
	/**
	 * 是否单用户登录(启用时：一个账号在PC和移动端只允许登录一次)
	 */
	private boolean single;
	/**
	 * 严格校验模式(必须单用户登录时才生效，严格校验模式下：加入token的状态管理)
	 */
	private boolean stricty;
	/**
	 * 有效期（单位：秒）
	 */
	private int expiration;

	public String getHeader() {
		return header;
	}

	public void setHeader(String header) {
		this.header = header;
	}

	public String getSecret() {
		return secret;
	}

	public void setSecret(String secret) {
		this.secret = secret;
	}

	public boolean isSingle() {
		return single;
	}

	public void setSingle(boolean single) {
		this.single = single;
	}

	public int getExpiration() {
		return expiration;
	}
	
	public long getExpirationLong() {
		return expiration;
	}

	public void setExpiration(int expiration) {
		this.expiration = expiration;
	}

	public boolean isStricty() {
		return stricty;
	}

	public void setStricty(boolean stricty) {
		this.stricty = stricty;
	}
}
