package com.artfess.uc.api.impl.service;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 类 {@code UserServiceImpl} 用户服务的实现
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年7月9日
 */
@Primary
@Service
public class UserServiceImpl implements IUserService {
	@Resource
	UCFeignService ucFeignService;
	@Resource
	UserCacheImpl userCacheImpl;

	// 获得ObjectNode
	private ObjectNode getObjectNode() {
		return JsonUtil.getMapper().createObjectNode();
	}

	public IUser getUserById(String userId)  {
		try {
			UserFacade userfacade = userCacheImpl.getUserFromCacheById(userId);
			if(userfacade!=null) {
				return userfacade;
			}
			CommonResult<JsonNode> ObjectNode = ucFeignService.getUserById(userId);
			if(ObjectNode.getState()){
				userfacade = JsonUtil.toBean(ObjectNode.getValue(), UserFacade.class);
				userCacheImpl.putUserInCache(userfacade);
				return userfacade;
			}else{
				return null;
			}
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}


	@Override
	public IUser getUserByAccount(String account)  {
		try {
			JsonNode result = ucFeignService.getUser(account, "");
 			if(BeanUtils.isEmpty(result)){
				return null;
			}
			UserFacade bean = JsonUtil.toBean(result, UserFacade.class);
			return bean;
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public List<IUser> getUserByAccounts(String accounts)  {
		ObjectNode params=getObjectNode();
		params.put("accounts", accounts);
		try {
			ArrayNode node = ucFeignService.getUserByAccounts(accounts);
			List<IUser> bean = new ArrayList<IUser>();
			for(JsonNode j :node){
				bean.add(JsonUtil.toBean(j, UserFacade.class));
			}
			return bean;
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public List<IUser> getUserListByGroup(String groupType, String groupId)  {
		// 此处可以根据不同的groupType去调用真实的实现：如角色下的人，组织下的人
		JsonNode result= JsonUtil.getMapper().createObjectNode();
		if (groupType.equals(GroupTypeConstant.ORG.key())) {
			QueryFilter queryFilter=QueryFilter.build();
			queryFilter.setPageBean(new PageBean(1, PageBean.WITHOUT_PAGE));
			queryFilter.addFilter("org_id_", groupId, QueryOP.EQUAL);
			result = ucFeignService.getAllOrgUsers(queryFilter);
		}
		if (groupType.equals(GroupTypeConstant.ROLE.key())) {
			result = ucFeignService.getUsersByRoleCode(groupId);
		}
		if (groupType.equals(GroupTypeConstant.POSITION.key())) {
			result = ucFeignService.getUserByPost(groupId);
		}

		if (groupType.equals(GroupTypeConstant.JOB.key())) {
			result = ucFeignService.getUsersByJob(groupId);
		}
		if (BeanUtils.isEmpty(result)) {
			return new ArrayList<>();
		}
		List<UserFacade> list = null;
		try {
			list = (List<UserFacade>) JsonUtil.toBean(!groupType.equals(GroupTypeConstant.ORG.key())?JsonUtil.toJson(result):JsonUtil.toJson(result.get("rows")),new TypeReference<List<UserFacade>>(){});
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
		List<IUser> Ilist = new ArrayList<>();
		for (UserFacade user : list) {
			Ilist.add((IUser)user);
		}
		return Ilist;
	}

	@Override
	public List<IUser> getUserListByGroups(String groupType, String groupIds)  {
		// 此处可以根据不同的groupType去调用真实的实现：如角色下的人，组织下的人
		JsonNode result= JsonUtil.getMapper().createObjectNode();
		result = ucFeignService.getAllOrgsUsers(groupIds);
		if (BeanUtils.isEmpty(result)) {
			return new ArrayList<>();
		}
		List<UserFacade> list = null;
		try {
			list = (List<UserFacade>) JsonUtil.toBean(!groupType.equals(GroupTypeConstant.ORG.key())?JsonUtil.toJson(result):JsonUtil.toJson(result.get("rows")),new TypeReference<List<UserFacade>>(){});
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
		List<IUser> Ilist = new ArrayList<>();
		for (UserFacade user : list) {
			Ilist.add((IUser)user);
		}
		return Ilist;
	}

	@Override
	public List<IUser> getByEmail(String email) {
		ObjectNode params=getObjectNode();
		params.put("email", email);
		List<UserFacade> list = null;
		try {

			JsonNode result = ucFeignService.getUserByEmail(email);

			list = (List<UserFacade>) JsonUtil.toBean(JsonUtil.toJson(result),new TypeReference<List<UserFacade>>(){});
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
		List<IUser> Ilist = new ArrayList<>();
		if(BeanUtils.isNotEmpty(list)) {
			for (UserFacade user : list) {
				Ilist.add((IUser)user);
			}
		}
		return Ilist;
	}

	@Override
	public IUser getSuperior(String underId, String demId) {
		try {
			JsonNode result = ucFeignService.getSuperior(underId, demId);
 			if(BeanUtils.isEmpty(result)){
				return null;
			}
			UserFacade bean = JsonUtil.toBean(result, UserFacade.class);
			return bean;
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public Object getMainPostOrOrgByUserId(String startId) {
		try {
			JsonNode result = ucFeignService.getMainPostOrOrgByUserId(startId);
 			if(BeanUtils.isEmpty(result)){
				return null;
			}
			return result;
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public Object getSuperiorPost(String userId) {
		try {
			JsonNode result = ucFeignService.getSuperiorPost(userId);
			if(BeanUtils.isEmpty(result)){
				return null;
			}
			return result;
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public List<IUser> getUserByIds(String userIds)  {
		try {
			ArrayNode ObjectNode = ucFeignService.getUserByIds(userIds);
			List<IUser> bean = new ArrayList<IUser>();
			if (BeanUtils.isNotEmpty(ObjectNode)) {
				for(JsonNode j :ObjectNode){
					bean.add(JsonUtil.toBean(j, UserFacade.class));
				}
			}
			return bean;

		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public List<IUser> findByPostIds(String posIds) {
		try {
			ArrayNode ObjectNode = ucFeignService.findByPostIds(posIds);
			List<IUser> bean = new ArrayList<IUser>();
			if (BeanUtils.isNotEmpty(ObjectNode)) {
				for(JsonNode j :ObjectNode){
					bean.add(JsonUtil.toBean(j, UserFacade.class));
				}
			}
			return bean;

		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
	}

}
