package com.artfess.table.factory;

import com.artfess.base.constants.SQLConst;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.meta.impl.DB2TableMeta;
import com.artfess.table.meta.impl.DmTableMeta;
import com.artfess.table.meta.impl.H2TableMeta;
import com.artfess.table.meta.impl.MySQLTableMeta;
import com.artfess.table.meta.impl.OracleTableMeta;
import com.artfess.table.meta.impl.PostgreSQLTableMeta;
import com.artfess.table.meta.impl.SQLServer2005TableMeta;
import com.artfess.table.meta.impl.SQLServerTableMeta;
import com.artfess.table.operator.IIndexOperator;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.operator.IViewOperator;
import com.artfess.table.operator.impl.db2.DB2IndexOperator;
import com.artfess.table.operator.impl.db2.DB2TableOperator;
import com.artfess.table.operator.impl.db2.DB2ViewOperator;
import com.artfess.table.operator.impl.dm.DmIndexOperator;
import com.artfess.table.operator.impl.dm.DmTableOperator;
import com.artfess.table.operator.impl.dm.DmViewOperator;
import com.artfess.table.operator.impl.h2.H2IndexOperator;
import com.artfess.table.operator.impl.h2.H2TableOperator;
import com.artfess.table.operator.impl.h2.H2ViewOperator;
import com.artfess.table.operator.impl.mysql.MySQLIndexOperator;
import com.artfess.table.operator.impl.mysql.MySQLTableOperator;
import com.artfess.table.operator.impl.mysql.MySQLViewOperator;
import com.artfess.table.operator.impl.oracle.OracleIndexOperator;
import com.artfess.table.operator.impl.oracle.OracleTableOperator;
import com.artfess.table.operator.impl.oracle.OracleViewOperator;
import com.artfess.table.operator.impl.postgresql.PostgreSQLIndexOperator;
import com.artfess.table.operator.impl.postgresql.PostgreSQLTableOperator;
import com.artfess.table.operator.impl.postgresql.PostgreSQLViewOperator;
import com.artfess.table.operator.impl.sqlserver.SQLServerIndexOperator;
import com.artfess.table.operator.impl.sqlserver.SQLServerTableOperator;
import com.artfess.table.operator.impl.sqlserver.SQLServerViewOperator;

/**
 * 元数据读取工厂
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月25日
 */
public class DatabaseFactory {

    public static String EXCEPTION_MSG = "没有设置合适的数据库类型";

    /**
     * 通过数据库类型获得表操作
     *
     * @param dbType 数据库类型
     * @return
     * @throws Exception
     */
    public static ITableOperator getTableOperator(String dbType) throws Exception {
        ITableOperator tableOperator = null;
        if (dbType.equals(SQLConst.DB_ORACLE)) {
            tableOperator = new OracleTableOperator();
        } else if (dbType.equals(SQLConst.DB_MYSQL)) {
            tableOperator = new MySQLTableOperator();
        } else if (dbType.equals(SQLConst.DB_SQLSERVER) || dbType.equals(SQLConst.DB_SQLSERVER2005)) {
            tableOperator = new SQLServerTableOperator();
        } else if (dbType.equals(SQLConst.DB_DB2)) {
            tableOperator = new DB2TableOperator();
        } else if (dbType.equals(SQLConst.DB_H2)) {
            tableOperator = new H2TableOperator();
        } else if (dbType.equals(SQLConst.DB_DM)) {
            tableOperator = new DmTableOperator();
        } else if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
            tableOperator = new PostgreSQLTableOperator();
        }else if (dbType.equals(SQLConst.DB_OCEANBASE)) {
            //支持oceanbase
            tableOperator = new MySQLTableOperator();
        }
        else {
            throw new Exception(EXCEPTION_MSG);
        }
        return tableOperator;
    }

    /**
     * 通过数据库类型获得表元操作
     *
     * @param dbType 数据库类型
     * @return
     * @throws Exception
     */
    public static BaseTableMeta getTableMetaByDbType(String dbType) throws Exception {
        BaseTableMeta meta = null;
        if (dbType.equals(SQLConst.DB_ORACLE)) {
            meta = new OracleTableMeta();
        } else if (dbType.equals(SQLConst.DB_MYSQL)) {
            meta = new MySQLTableMeta();
        } else if (dbType.equals(SQLConst.DB_SQLSERVER)) {
            meta = new SQLServerTableMeta();
        } else if (dbType.equals(SQLConst.DB_SQLSERVER2005)) {
            meta = new SQLServer2005TableMeta();
        } else if (dbType.equals(SQLConst.DB_DB2)) {
            meta = new DB2TableMeta();
        } else if (dbType.equals(SQLConst.DB_H2)) {
            meta = new H2TableMeta();
        } else if (dbType.equals(SQLConst.DB_DM)) {
            meta = new DmTableMeta();
        } else if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
            meta = new PostgreSQLTableMeta();
        }else if (dbType.equals(SQLConst.DB_OCEANBASE)) {
            meta = new MySQLTableMeta();
        }
        else {
            throw new Exception(EXCEPTION_MSG);
        }
        return meta;
    }

    /**
     * 根据数据类型获取 索引操作
     *
     * @param dbType
     * @return
     * @throws Exception
     */
    public static IIndexOperator getIndexOperator(String dbType) throws Exception {
        IIndexOperator indexOperator = null;
        if (dbType.equals(SQLConst.DB_ORACLE)) {
            indexOperator = new OracleIndexOperator();
        } else if (dbType.equals(SQLConst.DB_MYSQL)) {
            indexOperator = new MySQLIndexOperator();
        } else if (dbType.equals(SQLConst.DB_SQLSERVER) || dbType.equals(SQLConst.DB_SQLSERVER2005)) {
            indexOperator = new SQLServerIndexOperator();
        } else if (dbType.equals(SQLConst.DB_DB2)) {
            indexOperator = new DB2IndexOperator();
        } else if (dbType.equals(SQLConst.DB_H2)) {
            indexOperator = new H2IndexOperator();
        } else if (dbType.equals(SQLConst.DB_DM)) {
            indexOperator = new DmIndexOperator();
        } else if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
            indexOperator = new PostgreSQLIndexOperator();
        }else if (dbType.equals(SQLConst.DB_OCEANBASE)) {
            indexOperator = new MySQLIndexOperator();
        }
        else {
            throw new Exception(EXCEPTION_MSG);
        }
        return indexOperator;

    }

    /**
     * 根据数据源获取 视图操作
     *
     * @param dbType
     * @return
     * @throws Exception
     */
    public static IViewOperator getViewOperator(String dbType) throws Exception {

        IViewOperator view = null;
        if (dbType.equals(SQLConst.DB_ORACLE)) {
            view = new OracleViewOperator();
        } else if (dbType.equals(SQLConst.DB_MYSQL)) {
            view = new MySQLViewOperator();
        } else if (dbType.equals(SQLConst.DB_SQLSERVER) || dbType.equals(SQLConst.DB_SQLSERVER2005)) {
            view = new SQLServerViewOperator();
        } else if (dbType.equals(SQLConst.DB_DB2)) {
            view = new DB2ViewOperator();
        } else if (dbType.equals(SQLConst.DB_H2)) {
            view = new H2ViewOperator();
        } else if (dbType.equals(SQLConst.DB_DM)) {
            view = new DmViewOperator();
        } else if (dbType.equals(SQLConst.DB_POSTGRESQL)) {
            view = new PostgreSQLViewOperator();
        }else if (dbType.equals(SQLConst.DB_OCEANBASE)) {
            view = new MySQLViewOperator();
        }
        else {
            throw new Exception(EXCEPTION_MSG);
        }

        return view;
    }
}
