package com.artfess.file.config;

import com.artfess.file.util.MinioUtil;
import io.minio.MinioClient;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * Minio文件上传配置文件
 */
@Configuration
@Data
public class MinioSetting {

    @Value(value = "${minio.minio_url}")
    private String minioUrl;

    @Value(value = "${minio.minio_name}")
    private String minioName;

    @Value(value = "${minio.minio_pass}")
    private String minioPass;

    @Value(value = "${minio.bucketName}")
    private String bucketName;

    @Bean
    public MinioClient getMinioClient()
    {
//        if(!minioUrl.endsWith("/")){
//            minioUrl = minioUrl.concat("/");
//        }
        MinioUtil.setMinioUrl(minioUrl);
        MinioUtil.setMinioName(minioName);
        MinioUtil.setMinioPass(minioPass);
        MinioUtil.setBucketName(bucketName);
        try{
            MinioClient build = MinioClient.builder().endpoint(minioUrl).credentials(minioName, minioPass).build();
            return build;
        }catch (Exception e) {
            e.printStackTrace();
        }
        return null;

    }

//    @Bean
//    public void initMinio(){
////        if(!minioUrl.startsWith("http")){
////            minioUrl = "http://" + minioUrl;
////        }
//        if(!minioUrl.endsWith("/")){
//            minioUrl = minioUrl.concat("/");
//        }
//        MinioUtil.setMinioUrl(minioUrl);
//        MinioUtil.setMinioName(minioName);
//        MinioUtil.setMinioPass(minioPass);
//        MinioUtil.setBucketName(bucketName);
//    }

}
