package com.artfess.base.conf;

import javax.servlet.Filter;
import java.util.HashMap;
import java.util.Map;

/**
 * 微服务对 WebSecurity 配置的扩展接口
 * @author mikel
 *
 */
public interface WebSecurityExtend {

	/**
	 * 获取扩展的自定义过滤器
	 * @return
	 */
	default Map<Class<? extends Filter>, Filter> getCustomBeforeFilter() {
		return new HashMap<>();
	}
	
	/**
	 * 获取扩展的忽略Post请求Api地址
	 * @return
	 */
	default String[] getIgnoringPostUrl() {
		return new String[] {};
	}
	
	/**
	 * 获取扩展的忽略Get请求Api地址
	 * @return
	 */
	default String[] getIgnoringGetUrl() {
		return new String[] {};
	}

	/**
	 * 获取扩展的忽略所有方式请求的Api地址
	 * @return
	 */
	default String[] getIgnoringUrl() {
		return new String[] {};
	}
}
/**
 * 空实现
 * @author mikel
 */
class WebSecurityEmptyExtend implements WebSecurityExtend {
	
}
