package com.artfess.activemq.model;

import com.artfess.base.util.StringUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * JMS消息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年10月9日
 */
public class JmsTableTypeConf {

	private static  Map<String, List<JmsTableTypeFiledDetail>> typeConf = new  HashMap<>();
	

	private JmsTableTypeConf() {
	}


	public static Map<String, List<JmsTableTypeFiledDetail>> getTypeConf() {
		return typeConf;
	}

	public static void AddTypeConf(String typeKey,JmsTableTypeFiledDetail detail) {
		if (StringUtil.isNotEmpty(typeKey) && StringUtil.isNotEmpty(detail.getTableName())) {
			List<JmsTableTypeFiledDetail> list = new ArrayList<>();
			if (typeConf.containsKey(typeKey.toUpperCase())) {
				list = typeConf.get(typeKey.toUpperCase());
			}
			for (JmsTableTypeFiledDetail jmsTableTypeFiledDetail : list) {
				if (jmsTableTypeFiledDetail.getTableName().equalsIgnoreCase(detail.getTableName())) {
					return;
				}
			}
			list.add(detail);
			typeConf.put(typeKey.toUpperCase(), list);
		}
	}
 
	
}
