/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.identity;

import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityConverter;
import com.artfess.bpm.api.helper.identity.UserQueryPluginHelper;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.context.BpmPluginContext;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmIdentityService;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.artfess.uc.api.model.IUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmIdentityService
implements BpmIdentityService {
    @Resource
    private NatProInstanceService natProInstanceService;
    @Resource
    private BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    private BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    private UserQueryPluginHelper userQueryPluginHelper;
    @Resource
    private BpmTaskManager bpmTaskManager;
    @Resource
    private BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    private BpmIdentityConverter bpmIdentityConverter;

    @Override
    public List<BpmIdentity> searchByNode(String procInstId, String nodeId) throws Exception {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
        Map<String, Object> variables = this.gotVariableMap(instance.getBpmnInstId());
        List<BpmPluginContext> bpmPluginContexts = this.getBpmPluginContexts(instance.getProcDefId(), nodeId);
        List<BpmIdentity> bpmIdentities = this.userQueryPluginHelper.query(bpmPluginContexts, variables, "user");
        return bpmIdentities;
    }

    private Map<String, Object> gotVariableMap(String bpmnInstId) {
        Map<String, Object> variables = this.natProInstanceService.getVariables(bpmnInstId);
        return variables;
    }

    private List<BpmPluginContext> getBpmPluginContexts(String processDefinitionId, String nodeId) throws Exception {
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(processDefinitionId, nodeId);
        List<BpmPluginContext> bpmPluginContexts = bpmNodeDef.getBpmPluginContexts();
        return bpmPluginContexts;
    }

    @Override
    public List<IUser> queryUsersByNode(String procInstId, String nodeId) throws Exception {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
        Map<String, Object> variables = this.gotVariableMap(instance.getBpmnInstId());
        List<BpmPluginContext> bpmPluginContexts = this.getBpmPluginContexts(instance.getProcDefId(), nodeId);
        List<IUser> users = this.userQueryPluginHelper.queryUsers(bpmPluginContexts, variables);
        return users;
    }

    @Override
    public List<BpmIdentity> queryByTask(String taskId) {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        return this.queryByBpmTask(bpmTask);
    }

    @Override
    public List<BpmIdentity> queryByBpmTask(String bpmnTaskId) {
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(bpmnTaskId);
        return this.queryByBpmTask(bpmTask);
    }

    @Override
    public List<BpmIdentity> queryByBpmTask(BpmTask bpmTask) {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        if (StringUtil.isNotZeroEmpty((String)bpmTask.getAssigneeId())) {
            BpmIdentity bpmIdentity = this.bpmIdentityConverter.convert("user", bpmTask.getAssigneeId());
            bpmIdentities.add(bpmIdentity);
        } else {
            List<DefaultBpmTaskCandidate> bpmTaskCandidates = this.bpmTaskCandidateManager.queryByTaskId(bpmTask.getId());
            bpmIdentities = this.convert(bpmTaskCandidates);
        }
        return bpmIdentities;
    }

    @Override
    public List<BpmIdentity> queryListByBpmTask(BpmTask bpmTask) {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        if (StringUtil.isNotZeroEmpty((String)bpmTask.getAssigneeId())) {
            BpmIdentity bpmIdentity = this.bpmIdentityConverter.convertValue("user", bpmTask.getAssigneeId());
            bpmIdentities.add(bpmIdentity);
            if (!bpmTask.getAssigneeId().equals(bpmTask.getOwnerId()) && StringUtil.isNotZeroEmpty((String)bpmTask.getOwnerId())) {
                bpmIdentities.add(this.bpmIdentityConverter.convertValue("user", bpmTask.getOwnerId()));
            }
        } else {
            List<DefaultBpmTaskCandidate> bpmTaskCandidates = this.bpmTaskCandidateManager.queryByTaskId(bpmTask.getId());
            bpmIdentities = this.convertValue(bpmTaskCandidates);
        }
        return bpmIdentities;
    }

    private List<BpmIdentity> convertValue(List<DefaultBpmTaskCandidate> candidates) {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        for (DefaultBpmTaskCandidate candidate : candidates) {
            BpmIdentity bpmIdentity = this.bpmIdentityConverter.convertValue(candidate.getType(), candidate.getExecutor());
            bpmIdentities.add(bpmIdentity);
        }
        return bpmIdentities;
    }

    private List<BpmIdentity> convert(List<DefaultBpmTaskCandidate> candidates) {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        for (DefaultBpmTaskCandidate candidate : candidates) {
            BpmIdentity bpmIdentity = this.bpmIdentityConverter.convert(candidate.getType(), candidate.getExecutor());
            bpmIdentities.add(bpmIdentity);
        }
        return bpmIdentities;
    }

    @Override
    public List<BpmIdentity> searchStartByNode(String defId, String nodeId) {
        return null;
    }

    @Override
    public List<BpmIdentity> searchByNodeIdOnStartEvent(String procDefId, String nodeId) throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        List<BpmPluginContext> bpmPluginContexts = this.getBpmPluginContexts(procDefId, nodeId);
        List<BpmIdentity> bpmIdentities = this.userQueryPluginHelper.query(bpmPluginContexts, variables, "user");
        return bpmIdentities;
    }
}

