/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.taskcallback;

import com.artfess.base.exception.BaseException;
import com.artfess.base.groovy.IScript;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TaskCallBackScript
implements IScript {
    @Autowired
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private BizContractManager contractManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;

    public void updateContractStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************\u6267\u884c\u91c7\u8d2d\u5408\u540c\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************\u6267\u884c\u91c7\u8d2d\u5408\u540c\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        this.contractManager.updateStatusByIds(businessKey, "5");
    }

    public void updateQualificationStatusById(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************\u6267\u884c\u8d44\u8d28\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************\u6267\u884c\u8d44\u8d28\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        this.qualificationLabelManager.updateApprovalStatusById(businessKey, "3");
    }

    public void updatePurApplicationStatusById(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        this.purchasingApplicationManager.modifyStatusById(businessKey, "3");
    }

    public void updateMatApprovalReleaseStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************\u6267\u884c\u91c7\u8d2d\u7acb\u9879\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************\u6267\u884c\u91c7\u8d2d\u7acb\u9879\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        if (this.matApprovalManager.getNoticeTypeById(businessKey) == 1) {
            this.matApprovalManager.modifyReleaseStatus(businessKey, "2");
        } else {
            this.projectApprovalManager.modifyReleaseStatus(businessKey, "2");
        }
    }

    public void updateMatApprovalCalibraStatus(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************\u6267\u884c\u5b9a\u6807\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************\u6267\u884c\u5b9a\u6807\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        if (this.matApprovalManager.getNoticeTypeById(businessKey) == 1) {
            this.matApprovalManager.modifyCalibraStatus(businessKey, "2");
        } else {
            this.projectApprovalManager.modifyCalibraStatus(businessKey, "2");
        }
    }

    public void updateUserParticipationById(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd) throws Exception {
        UserParticipation docPart;
        String businessKey = cmd.getBusinessKey();
        System.out.println("************************************************\u6267\u884c\u6709\u8d44\u8d28\u62a5\u540d\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        System.out.println(businessKey);
        System.out.println("************************************************\u6267\u884c\u6709\u8d44\u8d28\u62a5\u540d\u5ba1\u6838\u5b8c\u6210\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return;
        }
        UserParticipation userParticipation = (UserParticipation)((Object)this.userParticipationManager.getById((Serializable)((Object)businessKey)));
        if (BeanUtils.isNotEmpty((Object)userParticipation.getPrice()) && userParticipation.getPrice().compareTo(BigDecimal.ZERO) > 0) {
            userParticipation.setStatus(3);
        } else {
            userParticipation.setStatus(1);
        }
        if (BeanUtils.isNotEmpty((Object)userParticipation.getDocumentFeeId()) && BeanUtils.isNotEmpty((Object)((Object)(docPart = (UserParticipation)((Object)this.userParticipationManager.getById((Serializable)((Object)userParticipation.getDocumentFeeId()))))))) {
            if (docPart.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                docPart.setStatus(3);
                if (userParticipation.getPrice().compareTo(BigDecimal.ZERO) == 0) {
                    userParticipation.setStatus(4);
                }
            } else {
                docPart.setStatus(1);
            }
            this.userParticipationManager.updateById((Object)docPart);
        }
        this.userParticipationManager.updateById((Object)userParticipation);
    }

    public void completeTaskToMh(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, final ActionCmd cmd) throws Exception {
        String proInstId = cmd.getInstId();
        System.out.println("************************************************\u6267\u884c\u6d41\u7a0b\u540e\u7f6e\u63a8\u9001\u56de\u8c03\u51fd\u6570****************************************************");
        if (StringUtils.isBlank((CharSequence)proInstId)) {
            return;
        }
        this.foreignCallService.completeTaskToMh(proInstId);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                try {
                    TaskCallBackScript.this.createPorTask(cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseException("\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        });
    }

    public void createPorTask(ActionCmd cmd) throws Exception {
        List taskIds = this.bpmProcessInstanceManager.getBpmTaskIdByInstId(cmd.getInstId());
        if (BeanUtils.isNotEmpty((Object)taskIds) && taskIds.size() > 0) {
            for (String taskId : taskIds) {
                this.foreignCallService.pushTaskToMhByTaskId(taskId);
            }
        }
    }
}

