/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.BizSupplierTypeDao;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeEvaluationManager;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeManager;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.artfess.cgpt.supplier.model.BizSupplierTypeEvaluation;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizSupplierTypeManagerImpl
extends BaseManagerImpl<BizSupplierTypeDao, BizSupplierType>
implements BizSupplierTypeManager {
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizSupplierTypeEvaluationManager bizSupplierTypeEvaluationManager;

    @Override
    public PageList<BizSupplierType> queryAllByPage(QueryFilter<BizSupplierType> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        IPage<BizSupplierType> Ipage = ((BizSupplierTypeDao)this.baseMapper).queryAllByPage((IPage<BizSupplierType>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierType>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(Ipage);
    }

    @Override
    public void saveOrUpdateEntity(BizSupplierType entity) {
        List<BizSupplierTypeEvaluation> typeEvaluationList = entity.getBizSupplierTypeEvaluationLists();
        if (BeanUtils.isEmpty((Object)entity.getId()) && BeanUtils.isEmpty((Object)entity.getCode())) {
            entity.setCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "gysfl_flbm"));
        }
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BizSupplierTypeEvaluation::getSupplierTypeId, (Object)entity.getId());
            this.bizSupplierTypeEvaluationManager.remove((Wrapper)queryWrapper);
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(typeEvaluationList) && typeEvaluationList.size() > 0) {
            typeEvaluationList.stream().forEach(e -> e.setSupplierTypeId(entity.getId()));
            this.bizSupplierTypeEvaluationManager.saveBatch(typeEvaluationList);
        }
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        super.removeByIds(ids);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BizSupplierTypeEvaluation::getSupplierTypeId, ids);
        this.bizSupplierTypeEvaluationManager.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public boolean updateSequence(HashMap<String, Object> params) {
        Assert.notNull(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String key : params.keySet()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"SN_", params.get(key))).eq((Object)"ID_", (Object)key);
            this.update((Wrapper)updateWrapper);
        }
        return true;
    }
}

