/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.project.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.project.dao.ProjectLedgerDao;
import com.artfess.cgpt.project.manager.EngineeringProjectDetailManager;
import com.artfess.cgpt.project.manager.EquipmentProjectDetailManager;
import com.artfess.cgpt.project.manager.ProjectLedgerManager;
import com.artfess.cgpt.project.manager.ServiceProjectDetailManager;
import com.artfess.cgpt.project.model.EngineeringProjectDetail;
import com.artfess.cgpt.project.model.EquipmentProjectDetail;
import com.artfess.cgpt.project.model.ProjectLedger;
import com.artfess.cgpt.project.model.ServiceProjectDetail;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectLedgerManagerImpl
extends BaseManagerImpl<ProjectLedgerDao, ProjectLedger>
implements ProjectLedgerManager {
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private EquipmentProjectDetailManager equipmentDetailManager;
    @Autowired
    private ServiceProjectDetailManager serviceDetailManager;
    @Autowired
    private EngineeringProjectDetailManager engineeringDetailManager;
    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<ProjectLedger> queryAllByPage(QueryFilter<ProjectLedger> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<ProjectLedger> result = ((ProjectLedgerDao)this.baseMapper).queryAllByPage((IPage<ProjectLedger>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectLedger>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(ProjectLedger entity) {
        List<EquipmentProjectDetail> equipmentDetailList = entity.getEquipmentDetailList();
        List<EngineeringProjectDetail> engineeringDetailList = entity.getEngineeringDetailList();
        List<ServiceProjectDetail> serviceDetailList = entity.getServiceDetailList();
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            if (entity.getProjectType().equals(1)) {
                LambdaQueryWrapper serviceDetailQW = new LambdaQueryWrapper();
                serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId, (Object)entity.getId());
                this.serviceDetailManager.remove((Wrapper)serviceDetailQW);
            } else {
                LambdaQueryWrapper engineeringDetailQW = new LambdaQueryWrapper();
                engineeringDetailQW.eq(EngineeringProjectDetail::getProjectLedgerId, (Object)entity.getId());
                this.engineeringDetailManager.remove((Wrapper)engineeringDetailQW);
                LambdaQueryWrapper equipmentDetailQW = new LambdaQueryWrapper();
                equipmentDetailQW.eq(EquipmentProjectDetail::getProjectLedgerId, (Object)entity.getId());
                this.equipmentDetailManager.remove((Wrapper)equipmentDetailQW);
                LambdaQueryWrapper serviceDetailQW = new LambdaQueryWrapper();
                serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId, (Object)entity.getId());
                this.serviceDetailManager.remove((Wrapper)serviceDetailQW);
            }
        } else if (BeanUtils.isEmpty((Object)entity.getProjectCode())) {
            entity.setProjectCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "xmxx_xmbh"));
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(equipmentDetailList) && equipmentDetailList.size() > 0) {
            equipmentDetailList.stream().forEach(s -> s.setProjectLedgerId(entity.getId()));
            this.equipmentDetailManager.saveBatch(equipmentDetailList);
        }
        if (BeanUtils.isNotEmpty(engineeringDetailList) && engineeringDetailList.size() > 0) {
            engineeringDetailList.stream().forEach(s -> s.setProjectLedgerId(entity.getId()));
            this.engineeringDetailManager.saveBatch(engineeringDetailList);
        }
        if (BeanUtils.isNotEmpty(serviceDetailList) && serviceDetailList.size() > 0) {
            serviceDetailList.stream().forEach(s -> s.setProjectLedgerId(entity.getId()));
            this.serviceDetailManager.saveBatch(serviceDetailList);
        }
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        LambdaQueryWrapper equipmentDetailQW = new LambdaQueryWrapper();
        equipmentDetailQW.in(EquipmentProjectDetail::getProjectLedgerId, ids);
        this.equipmentDetailManager.remove((Wrapper)equipmentDetailQW);
        LambdaQueryWrapper engineeringDetailQW = new LambdaQueryWrapper();
        engineeringDetailQW.in(EngineeringProjectDetail::getProjectLedgerId, ids);
        this.engineeringDetailManager.remove((Wrapper)engineeringDetailQW);
        LambdaQueryWrapper serviceDetailQW = new LambdaQueryWrapper();
        serviceDetailQW.in(ServiceProjectDetail::getProjectLedgerId, ids);
        this.serviceDetailManager.remove((Wrapper)serviceDetailQW);
        super.removeByIds(ids);
    }

    @Override
    public ProjectLedger getDataById(String id) {
        ProjectLedger result = (ProjectLedger)((Object)super.getById((Serializable)((Object)id)));
        if (result.getProjectType().equals(1)) {
            LambdaQueryWrapper serviceDetailQW = new LambdaQueryWrapper();
            serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId, (Object)id);
            result.setServiceDetailList(this.serviceDetailManager.list((Wrapper)serviceDetailQW));
        } else {
            LambdaQueryWrapper equipmentDetailQW = new LambdaQueryWrapper();
            equipmentDetailQW.eq(EquipmentProjectDetail::getProjectLedgerId, (Object)id);
            result.setEquipmentDetailList(this.equipmentDetailManager.list((Wrapper)equipmentDetailQW));
            LambdaQueryWrapper engineeringDetailQW = new LambdaQueryWrapper();
            engineeringDetailQW.eq(EngineeringProjectDetail::getProjectLedgerId, (Object)id);
            result.setEngineeringDetailList(this.engineeringDetailManager.list((Wrapper)engineeringDetailQW));
            LambdaQueryWrapper serviceDetailQW = new LambdaQueryWrapper();
            serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId, (Object)id);
            result.setServiceDetailList(this.serviceDetailManager.list((Wrapper)serviceDetailQW));
        }
        return result;
    }
}

