/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.expert.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.dao.BizExpertTypeDao;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseExpertTypeManager;
import com.artfess.cgpt.expert.manager.BizExpertTypeManager;
import com.artfess.cgpt.expert.model.BizExpertDatabaseExpertType;
import com.artfess.cgpt.expert.model.BizExpertType;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizExpertTypeManagerImpl
extends BaseManagerImpl<BizExpertTypeDao, BizExpertType>
implements BizExpertTypeManager {
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizExpertDatabaseExpertTypeManager expertDatabaseExpertTypeManager;

    @Override
    public PageList<BizExpertType> queryAllByPage(QueryFilter<BizExpertType> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        IPage<BizExpertType> materialIPage = ((BizExpertTypeDao)this.baseMapper).queryAllByPage((IPage<BizExpertType>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizExpertType>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(materialIPage);
    }

    @Override
    public void saveOrUpdateEntity(BizExpertType entity) {
        if (BeanUtils.isEmpty((Object)entity.getExpertTypeCode())) {
            entity.setExpertTypeCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zjfl_flbh"));
        }
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            this.existData(entity);
        }
        super.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        List dataList = super.listByIds(ids);
        for (BizExpertType data : dataList) {
            this.existData(data);
        }
        super.removeByIds(ids);
    }

    void existData(BizExpertType data) {
        LambdaQueryWrapper qw1 = new LambdaQueryWrapper();
        qw1.eq(BizExpertDatabaseExpertType::getExpertTypeId, (Object)data.getId());
        if (this.expertDatabaseExpertTypeManager.count((Wrapper)qw1) > 0) {
            throw new BaseException("\u4e13\u5bb6\u5206\u7c7b\u3010" + data.getExpertTypeCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
    }
}

