import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizEnterpriseBusinessLicense/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格新增
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizEnterpriseBusinessLicense/v1/`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格详情
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizEnterpriseBusinessLicense/v1/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

        
// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .put(`/bizEnterpriseBusinessLicense/v1/`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/bizEnterpriseBusinessLicense/v1/?ids=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
