import menu from "@/api/menu.js";
import portal from "@/api/portal.js";

const state = {
  menus: [],
  frontMenus: [],
  personalMenus: [{
    alias: "personMenus",
    name: "个人设置",
    children: [{
      alias: "personInfo",
      menuIcon: "user",
      name: "个人信息",
    }, {
      alias: "msgCenter",
      menuIcon: "message",
      name: "消息列表",
    }],

  }]
};

const getters = {
  menus: function (state) {
    return state.menus;
  },
  frontMenus: function (state) {
    return state.frontMenus;
  }
};

const actions = {
  actionMenus({
    commit,
    state
  }) {
    return new Promise((resolve, reject) => {
      if (state.menus && state.menus.length >= 1) {
        resolve();
        return;
      }
      portal.getMenus().then(data => {
        sessionStorage.setItem("currentMenus", JSON.stringify(data));
        commit("mutationMenus", data);
        resolve(data);
      });
    });
  },
  actionFrontMenus({
    commit,
    state
  }) {
    return new Promise((resolve, reject) => {
      if (state.frontMenus && state.frontMenus.length >= 1) {
        resolve(state.frontMenus);
        return;
      }
      portal.getFrontMenus().then(data => {
        // data.push(state.personalMenus[0]);
        sessionStorage.setItem("currentFrontMenus", JSON.stringify(data));
        commit("mutationFrontMenus", data);
        resolve(data);
      });
    });
  },
  actionMenusEmpty({
    commit,
    state
  }) {
    return new Promise((resolve, reject) => {
      commit("mutationMenus", []);
    });
  },
  //附件在线预览
  onlinePreview({
    commit,
    state
  }, id) {
    return new Promise((resolve, reject) => {
      portal.onlinePreview(id, response => {
        resolve(response.data);
      });
    });
  },
  //附件下载
  downloadFile({
    commit,
    state
  }, id) {
    portal.downloadFile(id);
  },
  //获取用户头像
  downloadImg({
    commit,
    state
  }, fileId) {
    return new Promise((resolve, reject) => {
      portal.downloadImg(fileId, response => {
        resolve(response);
      });
    });
  },
};

const mutations = {
  mutationMenus(state, menus) {
    state.menus = menus;
  },
  mutationFrontMenus(state, frontMenus) {
    state.frontMenus = frontMenus;
  },
};

export default {
  namespaced: true,
  state,
  getters,
  actions,
  mutations
};