import req from '@/request.js'
const report = window.context.report
const currentUserInfo = eval('(' + window.sessionStorage['currentUser'] + ')')
const token = currentUserInfo.token
export default {
  getReportData(data) {
    return new Promise((resolve, reject) => {
      req
        .get(
          report +
            `jmreport/excelQuery?pageNo=${data.pageNo}&pageSize=${data.pageSize}&reportType=${data.reportType}&name=${data.name}&token=${data.token}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  getReportDataTemple(data) {
    return new Promise((resolve, reject) => {
      req
        .get(
          report +
            `jmreport/excelQueryByTemplate?pageNo=${data.pageNo}&pageSize=${data.pageSize}&reportType=${data.reportType}&name=${data.name}&token=${data.token}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //保存回去id
  save() {
    return new Promise((resolve, reject) => {
      req.post(report + `jmreport/save`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //删除模板
  delete(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(
          window.context.report + `jmreport/delete?id=${id}&token=${token}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //复制模板
  copyTemple(id) {
    return new Promise((resolve, reject) => {
      req
        .get(
          window.context.report + `jmreport/reportCopy?id=${id}&token=${token}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //分享模板
  shareTemple(id) {
    return new Promise((resolve, reject) => {
      req
        .get(
          window.context.report +
            `jmreport/share/queryJurisdiction?reportId=${id}&token=${token}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //创建分享链接
  shareUrl(data) {
    return new Promise((resolve, reject) => {
      req.post(window.context.report + `jmreport/share/addAndEdit`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取大屏管理的分类管理
  getClassific(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisualCategory/v1/listJson`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
    },
    //根据id删除大屏分类管理
    delClassific(id) {
        return new Promise((resolve, reject) => {
            req.remove(report + `bigScreen/bladeVisualCategory/v1/${id}`).then(
              resp => {
                resolve(resp.data)
              },
              error => {
                reject(error)
              }
            )
          })
    },
  //获取大屏管理的数据
  getList(data) {
    return new Promise((resolve, reject) => {
      req.post(report + `bigScreen/bladeVisual/v1/listJson`,data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //修改保存大屏分类管理
  editSave(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisualCategory/v1/save`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //根据id删除大屏管理
  delObj(id) {
    return new Promise((resolve, reject) => {
        req.remove(report + `bigScreen/bladeVisual/v1/${id}`).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //新建大屏管理
  buildBigScreen(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisual/v1/saveBladeVisualConfigVo`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //上传图片
  uploadPhoto(data) {
    return new Promise((resolve, reject) => {
      req.post(report + `bigScreen/bladeVisual/v1/uploadPhoto`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //修改发布状态
  updateStatus(data) {
    return new Promise((resolve, reject) => {
      req.post(report + `bigScreen/bladeVisual/v1/updateStatus?id=${data.id}&status=${data.status}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //修改可视化数据
  updateBladeVisualConfigVo(data) {
    return new Promise((resolve, reject) => {
      req.post(report + `bigScreen/bladeVisual/v1/updateBladeVisualConfigVo`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //获取地图管理的数据
  getMapManagement(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisualMap/v1/query`, {
          bladeVisualConfigVo: data
        }).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //地图管理修改保存
  mapEditSave(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisualMap/v1/save`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //删除地图管理
  mapDelete(id) {
    return new Promise((resolve, reject) => {
        req.remove(report + `bigScreen/bladeVisualMap/v1/${id}`).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //获取大屏数据源数据
  getBigscreenDataScouce(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisualDb/v1/query`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //根据id删除大屏数据源
  dataScouceDelete(id) {
    return new Promise((resolve, reject) => {
        req.remove(report + `bigScreen/bladeVisualDb/v1/${id}`).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //大屏数据源管理修改保存
  dataSourceEditSave(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `bigScreen/bladeVisualDb/v1/save`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
  //大屏中刷新数据
  dataSourceRefresh(data) {
    return new Promise((resolve, reject) => {
        req.post(report + `form/customQuery/v1/doQuery`, data).then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
      })
  },
}
