package com.artfess.uc.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 用户与外部通讯录关系表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author pangquan
 * @since 2020-10-30
 */
@TableName("uc_user_unite")
@ApiModel(value="UcUserUnite对象", description="用户与外部通讯录关系表")
public class UserUnite extends BaseModel<UserUnite> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户id")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "公众号openid")
    @TableField("OPEN_ID_")
    private String openId;

    @ApiModelProperty(value = "企业微信userid")
    @TableField("WX_WORK_ID_")
    private String wxWorkId;

    @ApiModelProperty(value = "阿里钉钉userid")
    @TableField("DINGTALK_ID_")
    private String dingtalkId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
    public String getWxWorkId() {
        return wxWorkId;
    }

    public void setWxWorkId(String wxWorkId) {
        this.wxWorkId = wxWorkId;
    }
    public String getDingtalkId() {
        return dingtalkId;
    }

    public void setDingtalkId(String dingtalkId) {
        this.dingtalkId = dingtalkId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "UcUserUnite{" +
            "id=" + id +
            ", userId=" + userId +
            ", openId=" + openId +
            ", wxWorkId=" + wxWorkId +
            ", dingtalkId=" + dingtalkId +
        "}";
    }
}
