package com.artfess.base.vo;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 岗位树
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-26
 */
@Data
public class OrgPositionTreeVo extends BaseTreeModel<OrgPositionTreeVo> implements Tree {


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<OrgPositionTreeVo> children = Lists.newArrayList();

    @ApiModelProperty(name = "type", notes = "类型 1 组织 2岗位")
    @TableField(exist = false)
    private String type;

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }
}
