package com.artfess.base.feign.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.io.Serializable;

/**
 * @author jason
 */
public class PortalDataSensitive implements Serializable {

    private static final long serialVersionUID = 1L;

    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @XmlAttribute(name = "dataSourceAlias")
    @TableField("DATA_SOURCE_ALIAS_")
    @ApiModelProperty(value = "数据源别名")
    protected String dataSourceAlias;

    @XmlAttribute(name = "tableName")
    @TableField("TABLE_NAME_")
    @ApiModelProperty(value = "表名")
    protected String tableName;

    @XmlAttribute(name = "desensitizationRules")
    @TableField("DESENSITIZATION_RULES_")
    @ApiModelProperty(value = "脱敏规则")
    protected String desensitizationRules;

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 返回 主键
     *
     * @return
     */
    public String getId() {
        return this.id;
    }

    public void setDataSourceAlias(String dataSourceAlias) {
        this.dataSourceAlias = dataSourceAlias;
    }

    /**
     * 返回 数据源别名
     *
     * @return
     */
    public String getDataSourceAlias() {
        return this.dataSourceAlias;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * 返回 表名
     *
     * @return
     */
    public String getTableName() {
        return this.tableName;
    }

    public void setDesensitizationRules(String desensitizationRules) {
        this.desensitizationRules = desensitizationRules;
    }

    /**
     * 返回 脱敏规则
     *
     * @return
     */
    public String getDesensitizationRules() {
        return this.desensitizationRules;
    }

    /**
     * @see Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", this.id)
                .append("dataSourceAlias", this.dataSourceAlias)
                .append("tableName", this.tableName)
                .append("desensitizationRules", this.desensitizationRules)
                .toString();
    }
}
