package com.artfess.examine.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * 年度考核成绩表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-12-07
 */
@Data
@ApiModel(value="ExamUserEvaluationDetail对象", description="年度考核成绩表")
public class ExamUserEvaluationDetail extends AutoFillModel<ExamUserEvaluationDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @Excel(name = "考生姓名", column = "A")
    @ApiModelProperty(value = "考生姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "考试记录id")
    @TableField("record_id_")
    private String recordId;

    @ApiModelProperty(value = "课目id")
    @TableField("subject_id_")
    private String subjectId;


    @ApiModelProperty(value = "评定")
    @TableField("level_")
    private Integer level;

    @Excel(name = "评价等级", column = "D")
    @TableField(exist = false)
    private String levelDesc;

    @ApiModelProperty(value = "岗位id")
    @TableField("position_id_")
    private String positionId;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

    @ApiModelProperty(value = "是否评级0：未评定，1：已评定")
    @TableField(exist = false)
    private Integer status;
    @Excel(name = "课目名称", column = "B")
    @ApiModelProperty(value = "课目名称")
    @TableField("subject_name_")
    private String subjectName;

    @Excel(name = "成绩", column = "C")
    @ApiModelProperty(value = "成绩")
    @TableField("score_")
    private String score = "0";

    @ApiModelProperty(value = "训练类型1：线上 2线下")
    @TableField("type_")
    private String type;

    @TableField(exist = false)
    @ApiModelProperty(name = "mobile", notes = "手机号码")
    protected String mobile;

    @TableField(exist = false)
    @ApiModelProperty(name = "sex", notes = "性别")
    protected String sex;

    @TableField(exist = false)
    @ApiModelProperty(name = "idCard", notes = "身份证号")
    protected String idCard;

    @TableField(exist = false)
    @ApiModelProperty(name = "birthday", notes = "生日")
    protected LocalDate birthday;

    @TableField(exist = false)
    @ApiModelProperty(name = "entryDate", notes = "入职日期")
    protected LocalDate entryDate;

    @TableField(exist = false)
    @ApiModelProperty(name = "education", notes = "学历")
    protected String education;

    @TableField(exist = false)
    @ApiModelProperty(name = "examTime", notes = "考核时间")
    protected String examTime;

    @ApiModelProperty(value = "考评类别（1专业共同 2专业岗位XX 3XX共同 4XX体育）")
    @TableField("category_")
    private String category;

}
