package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 我的收藏
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@ApiModel(value="ExamCollectMaterial对象", description="我的收藏")
public class ExamCollectMaterial extends BaseModel<ExamCollectMaterial> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "收藏人_ID")
    @TableField("collect_user_id_")
    private String collectUserId;

    @ApiModelProperty(value = "收藏资料_ID")
    @TableField("data_id_")
    private String dataId;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_")
    private String createBy;

    @ApiModelProperty(value = "创建单位")
    @TableField("create_org_id_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人员")
    @TableField("update_by_")
    private String updateBy;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "删除标记（1：已删除，0：未删除）")
    @TableField("is_dele_")
    private String isDele;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCollectUserId() {
        return collectUserId;
    }

    public void setCollectUserId(String collectUserId) {
        this.collectUserId = collectUserId;
    }

    public String getDataId() {
        return dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ExamCollectMaterial{" +
            "id=" + id +
            ", collectUserId=" + collectUserId +
            ", dataId=" + dataId +
            ", sn=" + sn +
            ", createBy=" + createBy +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateTime=" + updateTime +
            ", tenantId=" + tenantId +
            ", isDele=" + isDele +
        "}";
    }
}
