package com.artfess.examine.dao;

import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 试卷基础信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamPaperBaseDao extends BaseMapper<ExamPaperBase> {

    IPage<ExamPaperBase> findByPage(IPage<ExamPaperBase> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamPaperBase> convert2Wrapper);

    List<UserInfoVo> getAllUser();

    Long getYearPaperCount(@Param("vo") ExamPaperBase t);
}
