package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 训练器材数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizTrainEquipmentData对象", description="训练器材数据")
public class BizTrainEquipmentData extends AutoFillModel<BizTrainEquipmentData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择所属单位", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属单位id")
    @TableField("org_id_")
    private String orgId;

    @Excel(name = "所属单位", column = "A")
    @ApiModelProperty(value = "所属单位")
    @TableField("org_name")
    private String orgName;

    @Excel(name = "仓库位置", column = "B")
    @ApiModelProperty(value = "仓库位置")
    @TableField("warehouse_location_")
    private String warehouseLocation;

    @NotNull(message = "请填写器材名称", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "器材名称", column = "C")
    @ApiModelProperty(value = "器材名称")
    @TableField("name_")
    private String name;

    @NotNull(message = "请选择器材类型", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "器材类型", column = "D")
    @ApiModelProperty(value = "器材类型【字典】")
    @TableField("type_")
    private String type;

    @Excel(name = "计量单位", column = "E")
    @ApiModelProperty(value = "计量单位【字典】")
    @TableField("unit_")
    private String unit;

    @Excel(name = "总数", column = "F")
    @ApiModelProperty(value = "总数")
    @TableField("total_num_")
    private BigDecimal totalNum;

    @Excel(name = "堪用数", column = "G")
    @ApiModelProperty(value = "堪用数")
    @TableField("usable_num_")
    private BigDecimal usableNum;

    @Excel(name = "维修数", column = "H")
    @ApiModelProperty(value = "维修数")
    @TableField("repair_num_")
    private BigDecimal repairNum;

    @Excel(name = "报废数", column = "H")
    @ApiModelProperty(value = "报废数")
    @TableField("scrap_num_")
    private BigDecimal scrapNum;

    @Excel(name = "备注", column = "I")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
