package com.artfess.examine.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 资料分类授权表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-21
 */
@Data
public class ExamMaterialVo {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资料_ID")
    private String materialId;

    @ApiModelProperty(value = "权限受控类型（1：所有人  2：组织 3：用户）")
    private String accessControlType;

    @ApiModelProperty(value = "操作权限(1查询、2下载)")
    @TableField("auth_type_")
    private String authType;

    @ApiModelProperty(value = "受控对象list")
    private List<ExamMaterialTypeAuthVo> accessControlList;

}
